/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.renderer.radeox.filters;

import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.renderer.WikiRendererContextKeys;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.links.GenericLinkParser;
import com.atlassian.renderer.links.Link;
import com.atlassian.renderer.links.LinkResolver;
import com.atlassian.renderer.links.UnpermittedLink;
import com.atlassian.renderer.links.UnresolvedLink;
import com.atlassian.renderer.links.UrlLink;
import com.atlassian.renderer.util.UrlUtil;
import java.util.Iterator;
import org.radeox.api.engine.RenderEngine;
import org.radeox.filter.CacheFilter;
import org.radeox.filter.context.FilterContext;
import org.radeox.filter.regex.RegexTokenFilter;
import org.radeox.regex.MatchResult;

public class UrlFilter
extends RegexTokenFilter
implements CacheFilter {
    public static String URL_PATTERN = null;
    public static String PURE_URL_PATTERN = null;
    private LinkResolver linkResolver;

    public UrlFilter() {
        super(URL_PATTERN);
    }

    public void setLinkResolver(LinkResolver linkResolver) {
        this.linkResolver = linkResolver;
    }

    public void handleMatch(StringBuffer buffer, MatchResult result, FilterContext context) {
        PageContext pageContext = WikiRendererContextKeys.getPageContext(context.getRenderContext().getParameters());
        String url = result.group(2);
        buffer.append(result.group(1));
        Link link = this.linkResolver.createLink((RenderContext)pageContext, url);
        UrlFilter.handleUrlLink(link, pageContext, url, buffer, null);
    }

    public static void handleUrlLink(Link link, PageContext pageContext, String url, StringBuffer buffer, RenderEngine engine) {
        if (link instanceof UnresolvedLink || link instanceof UnpermittedLink) {
            buffer.append(url);
        } else {
            buffer.append(pageContext.getRenderedContentStore().addInline((Object)pageContext.getLinkRenderer().renderLink(link, (RenderContext)pageContext)));
        }
        pageContext.addExternalReference((Link)new UrlLink(new GenericLinkParser(url)));
    }

    static {
        Iterator it = UrlUtil.URL_PROTOCOLS.iterator();
        String protocols = "";
        while (it.hasNext()) {
            if (!protocols.equals("")) {
                protocols = protocols + "|";
            }
            protocols = protocols + it.next();
        }
        PURE_URL_PATTERN = "((" + protocols + ")(%[\\p{Digit}A-Fa-f][\\p{Digit}A-Fa-f]|[-_.!~*';/?:@#&=+$,\\p{Alnum}\\[\\]\\\\])+)";
        URL_PATTERN = "([^\"\\[\\|'!]|^)" + PURE_URL_PATTERN;
    }
}

