/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.renderer.radeox.macros;

import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.renderer.WikiRendererContextKeys;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.RenderedContentStore;
import com.atlassian.renderer.macro.BaseMacro;
import com.atlassian.user.User;
import com.opensymphony.util.TextUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Category;
import org.radeox.macro.parameter.MacroParameter;

public abstract class AbstractHtmlGeneratingMacro
extends BaseMacro {
    public static final Category log = Category.getInstance(AbstractHtmlGeneratingMacro.class);

    public final void execute(Writer writer, MacroParameter macroParameter) throws IllegalArgumentException, IOException {
        String content = this.getHtml(macroParameter);
        if (content != null && TextUtils.stringSet((String)content)) {
            String token = RenderedContentStore.getFromRenderContext((RenderContext)((RenderContext)macroParameter.getContext().getParameters().get("RENDER_CONTEXT"))).addBlock((Object)content);
            writer.write(token);
        }
    }

    protected abstract String getHtml(MacroParameter var1) throws IllegalArgumentException, IOException;

    protected String errorContent(String message) {
        return "<div class=\"error\">" + message + "</div>";
    }

    protected String parseParameterForKey(MacroParameter parameter, String key) {
        Map paramMap = parameter.getParams();
        String result = (String)paramMap.get(key);
        if (result == null) {
            result = (String)paramMap.get(" " + key);
        }
        if (result == null) {
            result = (String)paramMap.get(key + " ");
        }
        if (result == null) {
            result = (String)paramMap.get(" " + key + " ");
        }
        return result;
    }

    protected PageContext getPageContext(MacroParameter macroParameter) {
        Map contextParams = macroParameter.getContext().getParameters();
        PageContext context = WikiRendererContextKeys.getPageContext(contextParams);
        return context;
    }

    protected User getRemoteUser() {
        return AuthenticatedUserThreadLocal.getUser();
    }

    protected String buildBaseUrl(HttpServletRequest request, List ignoredKeys) {
        if (request == null) {
            return null;
        }
        String baseurl = GeneralUtil.appendAmpsandOrQuestionMark(request.getRequestURI());
        Enumeration keys = request.getParameterNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (ignoredKeys.contains(key)) continue;
            baseurl = baseurl + GeneralUtil.urlEncode(key) + "=" + GeneralUtil.urlEncode(request.getParameter(key)) + "&";
        }
        return baseurl;
    }

    protected boolean hasLoneParameter(MacroParameter macroParameter, String loneParameter) {
        for (String parameter : macroParameter.getParams().keySet()) {
            try {
                Integer.parseInt(parameter);
                if (!TextUtils.noNull((String)loneParameter).equals(macroParameter.getParams().get(parameter))) continue;
                return true;
            }
            catch (NumberFormatException e) {
            }
        }
        return false;
    }
}

