/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.renderer.radeox.macros;

import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.renderer.WikiRendererContextKeys;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.renderer.RenderedContentStore;
import com.atlassian.renderer.macro.BaseMacro;
import com.atlassian.renderer.util.RendererUtil;
import com.opensymphony.util.TextUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.radeox.macro.parameter.MacroParameter;

public class AnchorMacro
extends BaseMacro {
    private String[] myParamDescription = new String[]{"1: name"};

    public String getName() {
        return "anchor";
    }

    public String[] getParamDescription() {
        return this.myParamDescription;
    }

    public void execute(Writer writer, MacroParameter macroParameter) throws IllegalArgumentException, IOException {
        Map contextParams = macroParameter.getContext().getParameters();
        String anchor = AnchorMacro.generateAnchor(WikiRendererContextKeys.getPageContext(contextParams), macroParameter.get(0));
        writer.write("<a name=\"" + anchor + "\"></a>");
    }

    public static String generateAnchor(PageContext context, String anchorTitle) {
        String result = "";
        if (context.getPageTitle() != null) {
            result = context.getPageTitle() + "-";
        } else if (context.getSpaceKey() != null) {
            result = context.getSpaceKey() + "-";
        }
        result = result + RendererUtil.summarise((String)TextUtils.noNull((String)RenderedContentStore.stripTokens((String)anchorTitle)).trim());
        result = result.replaceAll(" ", "");
        return GeneralUtil.urlEncode(result);
    }
}

