/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.renderer.radeox.macros;

import com.atlassian.confluence.core.persistence.ContentEntityObjectDao;
import com.atlassian.confluence.renderer.radeox.macros.AbstractHtmlGeneratingMacro;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.user.User;
import com.opensymphony.util.TextUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Category;
import org.radeox.macro.parameter.MacroParameter;

public class ContentByUserMacro
extends AbstractHtmlGeneratingMacro {
    private Category log = Category.getInstance(((Object)((Object)this)).getClass());
    private String[] myParamDescription = new String[]{"1: user"};
    private UserAccessor userAccessor;
    private ContentEntityObjectDao contentEntityObjectDao;
    private PermissionManager permissionManager;

    public String getName() {
        return "content-by-user";
    }

    public String[] getParamDescription() {
        return this.myParamDescription;
    }

    public String getHtml(MacroParameter macroParameter) throws IllegalArgumentException, IOException {
        String username = TextUtils.noNull((String)macroParameter.get("user", 0)).trim();
        Map contextMap = MacroUtils.defaultVelocityContext();
        User user = this.fetchUser(username);
        List content = this.fetchContent(username);
        Collections.sort(content);
        contextMap.put("user", user);
        contextMap.put("content", content);
        try {
            return VelocityUtils.getRenderedTemplate("templates/macros/contentbyuser.vm", contextMap);
        }
        catch (Exception e) {
            this.log.error((Object)"Error while trying to assemble the ContentByUser result!", (Throwable)e);
            throw new IOException(e.getMessage());
        }
    }

    private User fetchUser(String username) {
        return this.userAccessor.getUser(username);
    }

    private List fetchContent(String username) {
        List result = this.contentEntityObjectDao.getContentAuthoredByUser(username);
        if (result == null || result.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return this.permissionManager.getPermittedEntities(AuthenticatedUserThreadLocal.getUser(), Permission.VIEW, result);
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    public void setContentEntityObjectDao(ContentEntityObjectDao contentEntityObjectDao) {
        this.contentEntityObjectDao = contentEntityObjectDao;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }
}

