/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.renderer.radeox.macros.include;

import com.atlassian.confluence.renderer.radeox.macros.AbstractHtmlGeneratingMacro;
import com.atlassian.confluence.security.trust.TrustedTokenFactory;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.util.http.ConfluenceHttpParameters;
import com.atlassian.confluence.util.http.httpclient.TrustedTokenAuthenticator;
import com.opensymphony.util.TextUtils;
import com.opensymphony.webwork.ServletActionContext;
import java.io.IOException;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpRecoverableException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.log4j.Category;

public abstract class AbstractHttpRetrievalMacro
extends AbstractHtmlGeneratingMacro {
    public static final Category log = Category.getInstance(AbstractHttpRetrievalMacro.class);
    public static final String HTTP_INCLUDE_STACK_HEADER = "X-Confluence-HTTP-Stack-Depth";
    public static final int HTTP_INCLUDE_STACK_MAX_DEPTH = 1;
    private TrustedTokenAuthenticator trustedTokenAuthenticator;
    private SettingsManager settingsManager;

    public void setTrustedTokenFactory(TrustedTokenFactory trustedTokenFactory) {
        this.trustedTokenAuthenticator = new TrustedTokenAuthenticator(trustedTokenFactory);
    }

    protected HttpMethod retrieveRemoteUrl(String url) throws IOException {
        return this.retrieveRemoteUrl(url, false);
    }

    protected HttpMethod retrieveRemoteUrl(String url, boolean useTrustedConnection) throws IOException {
        ConfluenceHttpParameters httpParameters;
        URL remoteUrl = new URL(url);
        HttpClient client = new HttpClient();
        if (System.getProperty("http.proxyHost") != null && !this.isNonProxyHost(remoteUrl.getHost())) {
            client.getHostConfiguration().setProxy(System.getProperty("http.proxyHost"), Integer.parseInt(System.getProperty("http.proxyPort", "80")));
        }
        if (!(httpParameters = this.settingsManager.getGlobalSettings().getConfluenceHttpParameters()).isEnabled()) {
            throw new IOException("External connections have been disabled");
        }
        this.setTimeouts(client, httpParameters);
        int includeStackDepth = 1;
        HttpServletRequest request = ServletActionContext.getRequest();
        if (request != null) {
            int existingDepth = TextUtils.parseInt((String)request.getHeader(HTTP_INCLUDE_STACK_HEADER));
            if (existingDepth >= 1) {
                throw new IOException("HTTP include stack depth of more than 1!");
            }
            if (existingDepth > 0) {
                includeStackDepth = existingDepth + 1;
            }
        }
        HttpMethod method = this.getMethod(url, useTrustedConnection, client);
        method.addRequestHeader(HTTP_INCLUDE_STACK_HEADER, Integer.toString(includeStackDepth));
        int statusCode = -1;
        for (int attempt = 0; statusCode == -1 && attempt < 3; ++attempt) {
            try {
                statusCode = client.executeMethod(method);
                if (statusCode < 300 || statusCode > 399) continue;
                Header locationHeader = method.getResponseHeader("location");
                if (locationHeader != null) {
                    String redirectLocation = locationHeader.getValue();
                    method = this.getMethod(url, useTrustedConnection, client);
                    statusCode = -1;
                    continue;
                }
                throw new IOException("URL returned an error. Status code: " + statusCode);
            }
            catch (HttpRecoverableException e) {
                log.info((Object)("A recoverable exception occurred for the " + (attempt + 1) + "th time, retrying." + e.getMessage()), (Throwable)e);
                continue;
            }
            catch (IOException e) {
                log.info((Object)"Failed to download file.", (Throwable)e);
                throw new IOException("Could not download[ " + url + "] : caused by : " + e.getMessage());
            }
        }
        if (statusCode == -1) {
            log.info((Object)"Failed to recover from exception.");
            throw new IOException("Failed to recover from an exception: " + url);
        }
        return method;
    }

    public void setSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    private HttpMethod getMethod(String url, boolean useTrustedConnection, HttpClient client) {
        return useTrustedConnection ? this.trustedTokenAuthenticator.makeMethod(client, url) : new GetMethod(url);
    }

    private boolean isNonProxyHost(String host) {
        String httpNonProxyHosts = System.getProperty("http.nonProxyHosts");
        if (!TextUtils.stringSet((String)httpNonProxyHosts)) {
            if (!TextUtils.stringSet((String)System.getProperty("http.nonProxyHost"))) {
                log.warn((Object)"The system property http.nonProxyHost is set. You probably meant to set http.nonProxyHosts.");
            }
            return false;
        }
        String[] nonProxyHosts = httpNonProxyHosts.split("\\|");
        for (int i = 0; i < nonProxyHosts.length; ++i) {
            if (!(nonProxyHosts[i].startsWith("*.") ? host.endsWith(nonProxyHosts[i].substring(2)) : (nonProxyHosts[i].startsWith("*") ? host.endsWith(nonProxyHosts[i].substring(1)) : host.equals(nonProxyHosts[i])))) continue;
            return true;
        }
        return false;
    }

    protected String errorContent(String s) {
        if (!TextUtils.stringSet((String)s)) {
            s = "An error occured with no message";
        }
        return "<span class=\"error\">" + s + "</span>";
    }

    protected String cleanUrlParentheses(String url) {
        if (url.indexOf(40) > 0) {
            url = url.replaceAll("\\(", "%28");
        }
        if (url.indexOf(41) > 0) {
            url = url.replaceAll("\\)", "%29");
        }
        if (url.indexOf("&amp;") > 0) {
            url = url.replaceAll("&amp;", "&");
        }
        return url;
    }

    private void setTimeouts(HttpClient client, ConfluenceHttpParameters confluenceHttpParameters) {
        HttpConnectionManagerParams params = client.getHttpConnectionManager().getParams();
        params.setSoTimeout(confluenceHttpParameters.getSocketTimeout());
        params.setConnectionTimeout(confluenceHttpParameters.getConnectionTimeout());
    }

    protected TrustedTokenAuthenticator.TrustedConnectionStatus getTrustedConnectionStatusFromMethod(HttpMethod method) {
        return this.trustedTokenAuthenticator.getTrustedConnectionStatus(method);
    }
}

