/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.renderer.v2.macros;

import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.http.HttpResponse;
import com.atlassian.confluence.util.http.HttpRetrievalService;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.RenderUtils;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import com.opensymphony.util.TextUtils;
import com.opensymphony.webwork.ServletActionContext;
import java.io.IOException;
import java.util.Map;
import org.apache.log4j.Category;

public abstract class BaseHttpRetrievalMacro
extends BaseMacro {
    public static final Category log = Category.getInstance(BaseHttpRetrievalMacro.class);
    private HttpRetrievalService httpRetrievalService;
    private UserAccessor userAccessor;

    public boolean isInline() {
        return false;
    }

    public boolean hasBody() {
        return false;
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.NO_RENDER;
    }

    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        String url = this.cleanupUrl(RenderUtils.getParameter((Map)parameters, (String)"url", (int)0));
        if (!TextUtils.stringSet((String)url)) {
            return RenderUtils.blockError((String)"Could not retrieve RSS feed: no URL", (String)"");
        }
        HttpResponse response = null;
        try {
            response = this.httpRetrievalService.get(url);
            if (response.isNotFound()) {
                String string = this.notFound(url);
                return string;
            }
            if (response.isNotPermitted()) {
                String string = this.notPermitted(url);
                return string;
            }
            if (response.isFailed()) {
                String string = this.failed(url, response);
                return string;
            }
            String string = this.successfulResponse(parameters, renderContext, url, response);
            return string;
        }
        catch (IOException e) {
            throw new MacroException("Unable to retrieve " + url + ": " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (response != null) {
                response.finish();
            }
        }
    }

    public abstract String successfulResponse(Map var1, RenderContext var2, String var3, HttpResponse var4) throws MacroException;

    public String notFound(String url) {
        return RenderUtils.blockError((String)("Could not retrieve " + url + " - Page Not Found"), (String)"");
    }

    public String notPermitted(String url) {
        return RenderUtils.blockError((String)("Could not retrieve " + url + " - Not Permitted"), (String)"");
    }

    public String failed(String url, HttpResponse response) {
        return RenderUtils.blockError((String)("Could not retrieve " + url + " - Request failed"), (String)response.getStatusMessage());
    }

    protected String cleanupUrl(String url) {
        if (url.indexOf(40) > 0) {
            url = url.replaceAll("\\(", "%28");
        }
        if (url.indexOf(41) > 0) {
            url = url.replaceAll("\\)", "%29");
        }
        if (url.indexOf("&amp;") > 0) {
            url = url.replaceAll("&amp;", "&");
        }
        return url;
    }

    public void setHttpRetrievalService(HttpRetrievalService httpRetrievalService) {
        this.httpRetrievalService = httpRetrievalService;
    }

    protected User getRemoteUser() {
        String principal = ServletActionContext.getRequest().getRemoteUser();
        if (this.userAccessor == null) {
            this.userAccessor = (UserAccessor)ContainerManager.getComponent((String)"userAccessor");
        }
        User user = this.userAccessor.getUser(principal);
        return user;
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }
}

