/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rpc.auth;

import com.atlassian.confluence.rpc.InvalidSessionException;
import com.atlassian.confluence.rpc.NotPermittedException;
import com.atlassian.confluence.rpc.auth.TokenAuthenticationManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import com.opensymphony.util.TextUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.log4j.Logger;

public class TokenAuthenticationInvocationHandler
implements InvocationHandler {
    private static final Logger log = Logger.getLogger(TokenAuthenticationInvocationHandler.class);
    private TokenAuthenticationManager tokenAuthenticationManager;
    private Object wrappedObject;

    public static Object makeAuthenticatingProxy(Object rpcService, Class publishedInterface) throws ClassNotFoundException {
        TokenAuthenticationInvocationHandler authHandler = (TokenAuthenticationInvocationHandler)ContainerManager.getComponent((String)"tokenAuthHandler");
        authHandler.setWrappedObject(rpcService);
        return Proxy.newProxyInstance(rpcService.getClass().getClassLoader(), new Class[]{publishedInterface}, (InvocationHandler)authHandler);
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if ("login".equals(method.getName())) {
            return this.tokenAuthenticationManager.login((String)args[0], (String)args[1]);
        }
        if ("logout".equals(method.getName())) {
            return new Boolean(this.tokenAuthenticationManager.logout((String)args[0]));
        }
        try {
            return this.handleAuthenticatedMethod(args, method);
        }
        catch (InvocationTargetException e) {
            log.error((Object)("Error during invokation of method: " + method.getName()), (Throwable)e);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Remote method threw exception: " + e.getTargetException()), e.getTargetException());
            }
            throw e.getTargetException();
        }
        catch (NotPermittedException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Permission error encountered when handling remote method: " + e.getMessage()));
            }
            throw e;
        }
        catch (Exception e) {
            log.warn((Object)("Unexpected error handling remote method: " + e.getMessage()), (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object handleAuthenticatedMethod(Object[] args, Method method) throws NotPermittedException, InvalidSessionException, IllegalAccessException, InvocationTargetException {
        Object returnValue;
        String token = (String)args[0];
        args[0] = "";
        User user = !TextUtils.stringSet((String)token) ? this.tokenAuthenticationManager.makeAnonymousUser() : this.tokenAuthenticationManager.makeNonAnonymousUserFromToken(token);
        if (!this.tokenAuthenticationManager.hasUseConfluencePermission(user)) {
            throw new NotPermittedException("User does not have Use Confluence permission");
        }
        User originalUser = AuthenticatedUserThreadLocal.getUser();
        try {
            AuthenticatedUserThreadLocal.setUser(user);
            returnValue = method.invoke(this.wrappedObject, args);
        }
        finally {
            AuthenticatedUserThreadLocal.setUser(originalUser);
        }
        return returnValue;
    }

    public void setWrappedObject(Object wrappedObject) {
        this.wrappedObject = wrappedObject;
    }

    public void setTokenAuthenticationManager(TokenAuthenticationManager tokenAuthenticationManager) {
        this.tokenAuthenticationManager = tokenAuthenticationManager;
    }
}

