/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rpc.soap;

import com.atlassian.confluence.core.ConfluenceSystemProperties;
import com.atlassian.confluence.rpc.RpcServer;
import com.atlassian.confluence.rpc.soap.AxisServletHack;
import com.atlassian.confluence.rpc.soap.ConfluenceAxisServerFactory;
import com.atlassian.confluence.servlet.ServletManager;
import com.atlassian.confluence.servlet.SpringManagedServlet;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.util.profiling.ProfilingPageFilter;
import com.atlassian.plugin.PluginAccessor;
import com.opensymphony.webwork.ServletActionContext;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axis.AxisProperties;
import org.apache.axis.encoding.TypeMappingImpl;
import org.apache.axis.transport.http.AxisServlet;
import org.apache.log4j.Category;

public class AxisSoapServer
implements RpcServer,
ServletManager {
    public static final Category log = Category.getInstance(AxisSoapServer.class);
    private AxisServlet axisServlet;
    private SettingsManager settingsManager;
    private PluginAccessor pluginAccessor;
    private ServletConfig cachedServletConfig;

    public void reloadConfiguration() {
        if (this.axisServlet == null) {
            log.info((Object)"AXIS soap service hasn't been initialised yet");
        } else {
            this.axisServlet = null;
        }
    }

    public void servletDestroyed(SpringManagedServlet springManagedServlet) {
        log.info((Object)"Terminating AXIS SOAP service (servlet destroyed)");
        this.axisServlet.destroy();
        this.axisServlet = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(SpringManagedServlet springManagedServlet, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.settingsManager.getGlobalSettings().isAllowRemoteApi()) {
            response.sendError(403, "Remote API is not enabled on this server. Ask a site administrator to enable it.");
            return;
        }
        if (this.cachedServletConfig == null) {
            throw new ServletException("AXIS SOAP service has not been initialised");
        }
        ClassLoader prevClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            if (this.axisServlet == null) {
                this.recycleAxisServlet(this.cachedServletConfig);
            }
            ServletActionContext.setRequest((HttpServletRequest)request);
            ServletActionContext.setResponse((HttpServletResponse)response);
            Thread.currentThread().setContextClassLoader(this.pluginAccessor.getClassLoader());
            this.axisServlet.service((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            ServletActionContext.setRequest(null);
            ServletActionContext.setResponse(null);
            Thread.currentThread().setContextClassLoader(prevClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void servletInitialised(SpringManagedServlet springManagedServlet, ServletConfig servletConfig) throws ServletException {
        if (this.axisServlet != null) {
            this.servletDestroyed(springManagedServlet);
        }
        log.info((Object)"Initialising AXIS SOAP service (servlet initialised)");
        ProfilingPageFilter.ensureFactorySetup(servletConfig);
        this.cachedServletConfig = servletConfig;
        ClassLoader prevClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.pluginAccessor.getClassLoader());
            AxisProperties.setProperty((String)"axis.ServerFactory", (String)ConfluenceAxisServerFactory.class.getName());
            AxisProperties.setProperty((String)"axis.doAutoTypes", (String)Boolean.TRUE.toString());
            if (ConfluenceSystemProperties.isDevMode()) {
                AxisProperties.setProperty((String)"axis.development.system", (String)Boolean.TRUE.toString());
            }
            TypeMappingImpl.dotnet_soapenc_bugfix = true;
            this.recycleAxisServlet(servletConfig);
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevClassLoader);
        }
    }

    private void recycleAxisServlet(ServletConfig servletConfig) throws ServletException {
        this.removeEngineFromServletContext(servletConfig);
        this.axisServlet = new AxisServlet();
        this.axisServlet.init(servletConfig);
    }

    private void removeEngineFromServletContext(ServletConfig servletConfig) {
        servletConfig.getServletContext().removeAttribute(servletConfig.getServletName() + AxisServletHack.ATTR_AXIS_ENGINE);
        servletConfig.getServletContext().removeAttribute(AxisServletHack.ATTR_AXIS_ENGINE);
    }

    public void setSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    public void setPluginAccessor(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }
}

