/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rpc.soap;

import com.atlassian.confluence.plugin.descriptor.rpc.SoapModuleDescriptor;
import com.atlassian.confluence.rpc.RpcServer;
import com.atlassian.confluence.rpc.auth.TokenAuthenticationInvocationHandler;
import com.atlassian.confluence.rpc.soap.BogusServletConfig;
import com.atlassian.confluence.servlet.ServletManager;
import com.atlassian.confluence.servlet.SpringManagedServlet;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.profiling.ProfilingPageFilter;
import com.atlassian.plugin.PluginAccessor;
import com.opensymphony.webwork.ServletActionContext;
import electric.glue.context.ServiceContext;
import electric.registry.Registry;
import electric.registry.RegistryException;
import electric.server.http.ServletServer;
import electric.util.Context;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Category;

public class GlueSoapServer
implements RpcServer,
ServletManager {
    public static final Category log = Category.getInstance(GlueSoapServer.class);
    private static final Map INIT_PARAMS_MAP = new HashMap();
    private ServletServer glueServer;
    private List publishedPaths = new ArrayList();
    private SettingsManager settingsManager;
    private PluginAccessor pluginAccessor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(SpringManagedServlet springManagedServlet, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.settingsManager.getGlobalSettings().isAllowRemoteApi()) {
            response.sendError(403, "Remote API is not enabled on this server. Ask a site administrator to enable it.");
            return;
        }
        if (this.glueServer == null && this.isUnsupportedJvm()) {
            response.sendError(503, "GLUE SOAP service not available. Please use the AXIS SOAP service instead.");
            return;
        }
        if (this.glueServer == null) {
            throw new ServletException("Glue SOAP service has not been initialised");
        }
        try {
            ServletActionContext.setRequest((HttpServletRequest)request);
            ServletActionContext.setResponse((HttpServletResponse)response);
            this.glueServer.service((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            ServletActionContext.setRequest(null);
            ServletActionContext.setResponse(null);
        }
    }

    public void servletInitialised(SpringManagedServlet springManagedServlet, ServletConfig servletConfig) throws ServletException {
        if (this.isUnsupportedJvm()) {
            log.error((Object)"Unable to run Glue SOAP service on JRockit Java runtime: http://jira.atlassian.com/browse/CONF-3859\n");
            log.error((Object)"Please use the AXIS SOAP service instead: http://confluence.atlassian.com/display/DOC/Confluence+SOAP+Provider+Migration");
            return;
        }
        if (this.glueServer != null) {
            this.servletDestroyed(springManagedServlet);
        }
        log.info((Object)"Initialising Glue SOAP service (servlet initialised)");
        ProfilingPageFilter.ensureFactorySetup(servletConfig);
        this.glueServer = new ServletServer();
        this.glueServer.init(BogusServletConfig.makeProxy(servletConfig, INIT_PARAMS_MAP));
        this.publishSoapServices();
    }

    public void servletDestroyed(SpringManagedServlet springManagedServlet) {
        log.info((Object)"Terminating Glue SOAP service (servlet destroyed)");
        if (this.glueServer != null) {
            this.glueServer.destroy();
            this.glueServer = null;
        }
    }

    public void reloadConfiguration() {
        if (this.isUnsupportedJvm()) {
            log.debug((Object)"Not reloading Glue SOAP endpoints under JRockit environment");
            return;
        }
        if (this.glueServer == null) {
            log.debug((Object)"Not reloading Glue SOAP endpoints before first request");
            return;
        }
        log.info((Object)"Reloading Glue SOAP endpoints");
        this.unpublishAllSoapServices();
        this.publishSoapServices();
    }

    public void setSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    public void setPluginAccessor(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    private boolean isUnsupportedJvm() {
        return System.getProperty("java.vm.name", "Unknown VM").indexOf("JRockit") >= 0;
    }

    private void publishSoapServices() {
        List handlers = this.pluginAccessor.getEnabledModuleDescriptorsByClass(SoapModuleDescriptor.class);
        for (SoapModuleDescriptor descriptor : handlers) {
            log.info((Object)("Adding handler: " + descriptor.getServicePath() + " (" + descriptor.getCompleteKey() + ")"));
            try {
                Object service = descriptor.getModule();
                Class publishedInterface = descriptor.getPublishedInterface();
                if (descriptor.isAuthenticated()) {
                    service = TokenAuthenticationInvocationHandler.makeAuthenticatingProxy(service, publishedInterface);
                }
                ServiceContext ctx = new ServiceContext();
                ctx.setProperty("wsdlName", (Object)descriptor.getServiceName());
                ctx.addEndpoint(GeneralUtil.getGlobalSettings().getBaseUrl() + "/rpc/soap/" + descriptor.getServicePath());
                Registry.publish((String)descriptor.getServicePath(), (Object)service, (Class)publishedInterface, (Context)ctx);
                this.publishedPaths.add(descriptor.getServicePath());
            }
            catch (Throwable t) {
                log.error((Object)("Unable to add Glue SOAP service: " + descriptor.getCompleteKey() + " - " + t), t);
            }
        }
    }

    private void unpublishAllSoapServices() {
        Iterator it = this.publishedPaths.iterator();
        while (it.hasNext()) {
            String path = (String)it.next();
            try {
                Registry.unpublish((String)path);
            }
            catch (RegistryException e) {
                log.warn((Object)("Unable to unpublish Glue SOAP service while rehashing: " + path));
            }
            it.remove();
        }
    }

    static {
        INIT_PARAMS_MAP.put("httpRegistryRoot", "/");
    }
}

