/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rpc.xmlrpc;

import com.atlassian.core.util.RandomGenerator;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;

public class SampleRpcTestClient {
    public static void main(String[] args) throws Exception {
        try {
            XmlRpcClient xmlrpc = new XmlRpcClient("http://localhost:8080/confluence/rpc/xmlrpc");
            System.out.println("\n\n\nFirst let's be naughty and try to call a method without logging in");
            try {
                xmlrpc.execute("confluence1.getSpaces", SampleRpcTestClient.makeParams("foo"));
                System.out.println("Should have blown up - what happened!");
                System.exit(-12);
            }
            catch (Exception e) {
                System.out.println("Good - we failed!");
                e.printStackTrace();
            }
            System.out.println("\n\n\nNow logging in properly... ");
            String token = (String)xmlrpc.execute("confluence1.login", SampleRpcTestClient.makeParams("charles", "charles"));
            System.out.println("login token = " + token);
            System.out.println("\n\n\nNow let's get some spaces... ");
            Vector spaces = (Vector)xmlrpc.execute("confluence1.getSpaces", SampleRpcTestClient.makeParams(token));
            System.out.println("spaces = " + spaces);
            String spaceKey = (String)((Hashtable)spaces.get(2)).get("key");
            System.out.println("\n\n\nNow let's get more detail on one space... ");
            Vector pages = (Vector)xmlrpc.execute("confluence1.getCurrentPages", SampleRpcTestClient.makeParams(token, spaceKey));
            System.out.println("pages = " + pages);
            System.out.println("\n\n\nHow about a detailed page?");
            String pageId = (String)((Hashtable)pages.get(0)).get("id");
            Hashtable page = (Hashtable)xmlrpc.execute("confluence1.getPage", SampleRpcTestClient.makeParams(token, pageId));
            System.out.println("page = " + page);
            System.out.println("\n\n\nHow about rendered page?");
            String result = (String)xmlrpc.execute("confluence1.renderContent", SampleRpcTestClient.makeParams(token, page.get("space"), pageId, page.get("content")));
            System.out.println("result = " + result);
            System.out.println("\n\n\nLet's check we can't get a barfed page... ");
            try {
                xmlrpc.execute("confluence1.getPage", SampleRpcTestClient.makeParams(token, "-1"));
            }
            catch (XmlRpcException e) {
                e.printStackTrace();
            }
            System.out.println("\n\n\nCan we add a new page I wonder?");
            Hashtable<String, String> addedPage = new Hashtable<String, String>();
            addedPage.put("space", "y");
            addedPage.put("title", "remote page " + RandomGenerator.randomPassword());
            addedPage.put("content", "this is a *remotely* _added_ page :)");
            page = (Hashtable)xmlrpc.execute("confluence1.storePage", SampleRpcTestClient.makeParams(token, addedPage));
            System.out.println("added page = " + page);
            System.out.println("\n\nLet's try to render some content remotely for fun...");
            String newPageId = (String)page.get("id");
            String html = (String)xmlrpc.execute("confluence1.renderContent", SampleRpcTestClient.makeParams(token, newPageId, ""));
            System.out.println("html = " + html);
            System.out.println("\n\nAhh, but can we render new content?");
            html = (String)xmlrpc.execute("confluence1.renderContent", SampleRpcTestClient.makeParams(token, newPageId, "preview updated - [no page]"));
            System.out.println("new html = " + html);
            System.out.println("\n\nOf course adding is not useful without updating");
            Hashtable updatedPage = (Hashtable)page.clone();
            updatedPage.put("content", "preview updated - [no page]");
            page = (Hashtable)xmlrpc.execute("confluence1.storePage", SampleRpcTestClient.makeParams(token, updatedPage));
            System.out.println("updated page = " + page);
            System.out.println("\n\nCan we search for pages?");
            Vector searchResults = (Vector)xmlrpc.execute("confluence1.search", SampleRpcTestClient.makeParams(token, "preview", new Integer(10)));
            System.out.println("searchResults = " + searchResults);
            System.out.println("\n\n\nNow we should be nice and logout... ");
            Boolean loggedOut = (Boolean)xmlrpc.execute("confluence1.logout", SampleRpcTestClient.makeParams(token));
            System.out.println("loggedOut = " + loggedOut);
            System.out.println("\n\n\nOops, can't logout twice!");
            loggedOut = (Boolean)xmlrpc.execute("confluence1.logout", SampleRpcTestClient.makeParams(token));
            System.out.println("loggedOut = " + loggedOut);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(-1);
        }
    }

    private static Vector makeParams(Object p1) {
        Vector<Object> params = new Vector<Object>();
        params.add(p1);
        return params;
    }

    private static Vector makeParams(Object p1, Object p2) {
        Vector params = SampleRpcTestClient.makeParams(p1);
        params.add(p2);
        return params;
    }

    private static Vector makeParams(Object p1, Object p2, Object p3) {
        Vector params = SampleRpcTestClient.makeParams(p1, p2);
        params.add(p3);
        return params;
    }

    private static Vector makeParams(Object p1, Object p2, Object p3, Object p4) {
        Vector params = SampleRpcTestClient.makeParams(p1, p2, p3);
        params.add(p4);
        return params;
    }

    private static Vector makeParams(Object p1, Object p2, Object p3, Object p4, Object p5) {
        Vector params = SampleRpcTestClient.makeParams(p1, p2, p3, p4);
        params.add(p5);
        return params;
    }
}

