/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rss;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.core.DateFormatter;
import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.core.ListQuery;
import com.atlassian.confluence.core.SmartListManager;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.rss.FeedBuilder;
import com.atlassian.confluence.rss.RssRenderItem;
import com.atlassian.confluence.rss.RssRenderSupport;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.io.IOUtils;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import com.atlassian.util.profiling.UtilTimerStack;
import com.opensymphony.util.TextUtils;
import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.hibernate.Hibernate;
import org.apache.log4j.Category;

public class DefaultFeedBuilder
implements FeedBuilder {
    public static final Category log = Category.getInstance(DefaultFeedBuilder.class);
    private SmartListManager smartListManager;
    private Map renderSupport = new HashMap();
    private UserAccessor userAccessor;
    private FormatSettingsManager formatSettingsManager;

    public SyndFeed createPublicFeed(ListQuery query, boolean showContent, boolean showDiff) {
        return this.createFeed(query, showContent, showDiff, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SyndFeed createFeed(ListQuery query, boolean showContent, boolean showDiff, User user) {
        UtilTimerStack.push((String)"DefaultFeedBuilder.createFeed()");
        log.debug((Object)"creating Feed");
        try {
            SyndFeedImpl feed = new SyndFeedImpl();
            feed.setTitle(this.getRssTitle(query));
            feed.setLink(this.getDomainName());
            feed.setUri(this.getDomainName());
            feed.setDescription(query.getDescription());
            ArrayList<SyndEntryImpl> entries = new ArrayList<SyndEntryImpl>();
            boolean sortByLastModified = true;
            if (query.getStatusList() != null && !query.getStatusList().isEmpty() && "created".equals(query.getStatusList().get(0))) {
                sortByLastModified = false;
            }
            List recentlyUpdatedContent = this.smartListManager.getListQueryResults(query, true);
            for (int i = 0; i < recentlyUpdatedContent.size(); ++i) {
                ConfluenceEntityObject entity = (ConfluenceEntityObject)recentlyUpdatedContent.get(i);
                RssRenderSupport renderer = (RssRenderSupport)this.renderSupport.get(Hibernate.getClass((Object)entity).getName());
                if (renderer == null) {
                    log.error((Object)("No RSS renderer found for :" + Hibernate.getClass((Object)entity).getName()));
                    continue;
                }
                User modifier = this.userAccessor.getUser(entity.getLastModifierName());
                RssRenderItem item = new RssRenderItem(entity, showContent, showDiff, modifier, user, this.getDateFormatter(user));
                SyndEntryImpl entry = new SyndEntryImpl();
                entry.setTitle(renderer.getTitle(item));
                entry.setLink(this.getDomainName() + renderer.getLink(item));
                SyndContentImpl description = new SyndContentImpl();
                description.setType("html");
                description.setValue(renderer.getRenderedContent(item).replaceAll("\\r", ""));
                entry.setDescription((SyndContent)description);
                entry.setAuthor(this.getUserFullName(entity.getLastModifierName()));
                if (sortByLastModified) {
                    entry.setPublishedDate(entity.getLastModificationDate());
                } else {
                    entry.setPublishedDate(entity.getCreationDate());
                }
                entry.setCategories(renderer.getCategories(item));
                entries.add(entry);
            }
            feed.setEntries(entries);
            log.debug((Object)"Feed Successfully Created");
            SyndFeedImpl syndFeedImpl = feed;
            return syndFeedImpl;
        }
        catch (Throwable t) {
            log.error((Object)("Feed Error:" + t), t);
            SyndFeed syndFeed = this.createErrorFeed(t);
            return syndFeed;
        }
        finally {
            UtilTimerStack.pop((String)"DefaultFeedBuilder.createFeed()");
        }
    }

    private DateFormatter getDateFormatter(User user) {
        return this.getUserAccessor().getConfluenceUserPreferences(user).getDateFormatter(this.formatSettingsManager);
    }

    private String getRssTitle(ListQuery query) {
        String rssTitle = query.getName();
        if (TextUtils.stringSet((String)rssTitle)) {
            return rssTitle;
        }
        rssTitle = "Confluence RSS Feed";
        return rssTitle;
    }

    private SyndFeed createErrorFeed(Throwable t) {
        SyndFeedImpl feed = new SyndFeedImpl();
        feed.setTitle("Confluence RSS Error Report");
        feed.setLink(this.getDomainName());
        feed.setDescription(t.toString());
        SyndEntryImpl entry = new SyndEntryImpl();
        entry.setTitle("Confluence RSS Error!");
        entry.setLink("http://www.atlassian.com/support");
        SyndContentImpl description = new SyndContentImpl();
        description.setType("html");
        String errorDescription = this.makeErrorDescription(t);
        String renderedErrorDescription = this.renderErrorDescription(errorDescription);
        description.setValue(renderedErrorDescription);
        entry.setDescription((SyndContent)description);
        ArrayList<SyndEntryImpl> entries = new ArrayList<SyndEntryImpl>();
        entries.add(entry);
        feed.setEntries(entries);
        return feed;
    }

    private String renderErrorDescription(String errorDescription) {
        Map contextMap = MacroUtils.defaultVelocityContext();
        contextMap.put("errorDescription", errorDescription);
        contextMap.put("i18n", new ConfluenceActionSupport());
        return VelocityUtils.getRenderedTemplate("templates/rss/error-rss-content.vm", contextMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String makeErrorDescription(Throwable t) {
        String string;
        PrintWriter pw = null;
        try {
            StringWriter sw = new StringWriter();
            pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            string = sw.toString().replaceAll("\n", "<br />");
        }
        catch (Throwable throwable) {
            IOUtils.close(pw);
            throw throwable;
        }
        IOUtils.close(pw);
        return string;
    }

    public String getDomainName() {
        return GeneralUtil.getGlobalSettings().getBaseUrl();
    }

    public void setSmartListManager(SmartListManager smartListManager) {
        this.smartListManager = smartListManager;
    }

    public String getUserFullName(String username) {
        if (!TextUtils.stringSet((String)username)) {
            return null;
        }
        User user = this.getUserAccessor().getUser(username);
        if (user == null) {
            log.warn((Object)("Unknown author in RSS feed, username: " + username));
            return null;
        }
        return user.getFullName();
    }

    public void setRenderSupport(Map renderSupport) {
        this.renderSupport = renderSupport;
    }

    public void setFormatSettingsManager(FormatSettingsManager formatSettingsManager) {
        this.formatSettingsManager = formatSettingsManager;
    }

    public UserAccessor getUserAccessor() {
        if (this.userAccessor == null) {
            this.userAccessor = (UserAccessor)ContainerManager.getComponent((String)"userAccessor");
        }
        return this.userAccessor;
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }
}

