/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rss;

import com.atlassian.confluence.mail.Mail;
import com.atlassian.confluence.rss.AbstractContentEntityRenderSupport;
import com.atlassian.confluence.rss.RssRenderItem;
import com.atlassian.confluence.rss.RssRenderSupport;
import com.atlassian.confluence.themes.MailHelper;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import java.util.Map;

public class MailRenderSupport
extends AbstractContentEntityRenderSupport
implements RssRenderSupport {
    private MailHelper mailHelper = new MailHelper();

    private Mail getMail(RssRenderItem item) {
        return (Mail)item.getEntity();
    }

    public String getTitle(RssRenderItem item) {
        Mail mail = this.getMail(item);
        return mail.getTitle() + " " + this.getText("rss.template.from") + ": " + this.mailHelper.getSender(mail);
    }

    public String getRenderedContent(RssRenderItem item) {
        Mail entity = this.getMail(item);
        Map contextMap = this.getContextMap(item);
        contextMap.put("entity", entity);
        contextMap.put("content", GeneralUtil.plain2html(entity.getMessageBody()));
        return VelocityUtils.getRenderedTemplate("templates/rss/mail-rss-content.vm", contextMap);
    }
}

