/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rss;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.rss.AbstractContentEntityRenderSupport;
import com.atlassian.confluence.rss.RssRenderItem;
import com.atlassian.confluence.rss.RssRenderSupport;
import com.atlassian.confluence.util.DiffUtils;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.user.User;
import java.util.Map;
import org.apache.commons.jrcs.diff.DifferentiationFailedException;
import org.apache.log4j.Category;

public class PageRenderSupport
extends AbstractContentEntityRenderSupport
implements RssRenderSupport {
    public static final Category log = Category.getInstance(PageRenderSupport.class);
    private PageManager pageManager;

    private AbstractPage getAbstractPage(RssRenderItem item) {
        return (AbstractPage)item.getEntity();
    }

    public String getTitle(RssRenderItem item) {
        AbstractPage content = this.getAbstractPage(item);
        String contentTitle = content.getDisplayTitle() == null ? content.getSpace().getName() : content.getTitle();
        return contentTitle;
    }

    public String getLink(RssRenderItem item) {
        return this.getAbstractPage(item).getUrlPath();
    }

    public String getRenderedContent(RssRenderItem item) {
        AbstractPage entity = this.getAbstractPage(item);
        Map contextMap = this.getContextMap(item);
        contextMap.put("showDiff", item.isShowDifferences() ? Boolean.TRUE : Boolean.FALSE);
        contextMap.put("showContent", item.isShowContent() ? Boolean.TRUE : Boolean.FALSE);
        contextMap.put("entity", entity);
        contextMap.put("spaceKey", entity.getSpaceKey());
        if (item.isShowDifferences()) {
            contextMap.put("diff", this.getDiff(entity));
        }
        if ("email.address.public".equals(this.settingsManager.getGlobalSettings().getEmailAddressVisibility())) {
            contextMap.put("creatorMail", this.getEmail(entity.getCreatorName()));
            contextMap.put("editorMail", this.getEmail(entity.getLastModifierName()));
        }
        return VelocityUtils.getRenderedTemplate("templates/rss/page-rss-content.vm", contextMap);
    }

    private String getEmail(String username) {
        User user = this.userAccessor.getUser(username);
        if (user == null) {
            log.info((Object)("Can not retrieve the user ('" + username + "')!"));
            return null;
        }
        return GeneralUtil.maskEmail(user.getEmail());
    }

    private String getDiff(ContentEntityObject entity) {
        ContentEntityObject previousVersion;
        if (entity instanceof AbstractPage && (previousVersion = this.pageManager.getPreviousVersion(entity)) != null) {
            return this.getHtmlDiff(entity, previousVersion);
        }
        return null;
    }

    private String getHtmlDiff(ContentEntityObject entity, ContentEntityObject previousVersion) {
        try {
            return DiffUtils.generateDiff(previousVersion, entity).getHtml();
        }
        catch (DifferentiationFailedException e) {
            return null;
        }
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }
}

