/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.actions;

import com.atlassian.bonnie.Searcher;
import com.atlassian.bonnie.search.SearchWordsLister;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.mail.Mail;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.search.actions.Timer;
import com.atlassian.confluence.search.scope.ModifiedSinceScope;
import com.atlassian.confluence.search.scope.PermittedSpacesScope;
import com.atlassian.confluence.search.scope.SpaceScope;
import com.atlassian.confluence.search.scope.TextScope;
import com.atlassian.confluence.search.scope.UserScope;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.SpaceDescription;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.PersonalInformation;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.user.User;
import com.opensymphony.util.TextUtils;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Category;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class SearchQueryBean
implements Serializable {
    public static final String CONTENT_ALL = "all";
    private static final Category log = Category.getInstance(SearchQueryBean.class);
    private static final Map TYPE_MAP = new HashMap();
    private Searcher searcher;
    private SpaceManager spaceManager;
    private UserAccessor userAccessor;
    private LabelManager labelManager;
    private SettingsManager settingsManager;
    private String queryString;
    private String spaceKey;
    private String type;
    private String groupBy;
    private String lastModified;
    private SearchWordsLister searchWordsLister;
    private Timer timer;
    private List spaceKeys;

    public SearchQueryBean() {
        this.searchWordsLister = new SearchWordsLister();
    }

    public SearchQueryBean(SearchQueryBean searchQueryBean) {
        this.searcher = searchQueryBean.searcher;
        this.spaceManager = searchQueryBean.spaceManager;
        this.userAccessor = searchQueryBean.userAccessor;
        this.labelManager = searchQueryBean.labelManager;
        this.settingsManager = searchQueryBean.settingsManager;
        this.queryString = searchQueryBean.queryString;
        this.spaceKey = searchQueryBean.spaceKey;
        this.type = searchQueryBean.type;
        this.groupBy = searchQueryBean.groupBy;
        this.lastModified = searchQueryBean.lastModified;
        this.timer = searchQueryBean.timer;
    }

    public SearchQueryBean(Searcher searcher, SpaceManager spaceManager, UserAccessor userAccessor, LabelManager labelManager, SettingsManager settingsManager) {
        this.searcher = searcher;
        this.spaceManager = spaceManager;
        this.userAccessor = userAccessor;
        this.labelManager = labelManager;
        this.settingsManager = settingsManager;
        this.searchWordsLister = new SearchWordsLister();
    }

    public void unwire() {
        this.spaceManager = null;
        this.userAccessor = null;
        this.labelManager = null;
        this.settingsManager = null;
        this.searcher = null;
    }

    public static String getTypeClass(String contentType) {
        if (StringUtils.isBlank((String)contentType)) {
            return null;
        }
        return (String)TYPE_MAP.get(contentType);
    }

    public Query buildQuery() {
        BooleanQuery query = (BooleanQuery)this.buildQueryNoSpaceLimit();
        if (this.timer != null) {
            this.timer.start("restrictSpaceSearch");
        }
        if (this.spaceKeys != null) {
            new SpaceScope(this.spaceKeys, this.labelManager).restrictQuery(null, query);
        } else {
            new SpaceScope(this.spaceKey, this.labelManager).restrictQuery(null, query);
        }
        if (this.timer != null) {
            this.timer.stop("restrictSpaceSearch");
        }
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query buildQueryNoSpaceLimit() {
        BooleanQuery query = new BooleanQuery();
        try {
            if (this.queryString != null && this.queryString.trim().length() > 0) {
                this.addSearchTerms(query, this.isMailIncluded());
            }
            if (TextUtils.stringSet((String)this.getTypeClass())) {
                this.addClassSearchField(query, this.getTypeClass());
            }
            if (TextUtils.stringSet((String)this.getLastModified())) {
                this.limitByDateModified(query);
            }
        }
        catch (Exception e) {
            log.warn((Object)("Unable to build search query: " + e.getMessage()), (Throwable)e);
            query = new BooleanQuery();
        }
        finally {
            if (this.timer != null) {
                this.timer.start("limitBySpaceVisibility");
            }
            this.limitBySpaceVisibility(query);
            if (this.timer != null) {
                this.timer.stop("limitBySpaceVisibility");
            }
        }
        return query;
    }

    public Query buildPeopleQuery(boolean onlyPeopleWithPersonalSpaces) {
        BooleanQuery query = new BooleanQuery();
        if (this.timer != null) {
            this.timer.start("restrictSpaceSearch");
        }
        if (this.spaceKeys != null) {
            new SpaceScope(this.spaceKeys, this.labelManager).restrictQuery(null, query);
        } else {
            new SpaceScope(this.spaceKey, this.labelManager).restrictQuery(null, query);
        }
        if (this.timer != null) {
            this.timer.stop("restrictSpaceSearch");
        }
        try {
            if (this.queryString != null && this.queryString.trim().length() > 0) {
                new UserScope(this.searcher, this.queryString, this.settingsManager).restrictQuery(null, query);
            }
            if (!this.settingsManager.getGlobalSettings().isSharedMode()) {
                query.add((Query)new TermQuery(new Term("type", "userinfo")), BooleanClause.Occur.MUST);
            }
            if (onlyPeopleWithPersonalSpaces) {
                query.add((Query)new TermQuery(new Term("hasPersonalSpace", String.valueOf(Boolean.TRUE))), BooleanClause.Occur.MUST);
            }
        }
        catch (Exception e) {
            log.warn((Object)("Unable to build search query: " + e.getMessage()), (Throwable)e);
            query = new BooleanQuery();
        }
        return query;
    }

    public Query buildSpaceQuery(String spaceKey) {
        BooleanQuery query = new BooleanQuery();
        query.add(this.buildQuery(), BooleanClause.Occur.MUST);
        new SpaceScope(spaceKey, this.labelManager).restrictQuery(null, query);
        return query;
    }

    public void addClassSearchField(BooleanQuery query, String typeClass) {
        query.add((Query)new TermQuery(new Term("classname", typeClass)), BooleanClause.Occur.MUST);
    }

    public Query buildTypeQuery(String type) {
        BooleanQuery query = new BooleanQuery();
        query.add(this.buildQuery(), BooleanClause.Occur.MUST);
        query.add((Query)new TermQuery(new Term("classname", SearchQueryBean.getTypeClass(type))), BooleanClause.Occur.MUST);
        return query;
    }

    private void limitByDateModified(BooleanQuery query) {
        new ModifiedSinceScope(this.getLastModified()).restrictQuery(null, query);
    }

    private void addSearchTerms(BooleanQuery query, boolean includeMail) {
        new TextScope(this.searcher, this.queryString, includeMail, this.settingsManager).restrictQuery(null, query);
    }

    private void updateSearchWordsLister(String queryString) {
        this.searchWordsLister = new SearchWordsLister();
        try {
            if (TextUtils.stringSet((String)queryString)) {
                this.searchWordsLister.parseQuery(queryString);
            }
        }
        catch (IOException e) {
            log.error((Object)("Error parsing search query: " + e.getMessage()), (Throwable)e);
        }
    }

    private void limitBySpaceVisibility(BooleanQuery query) {
        User user = AuthenticatedUserThreadLocal.getUser();
        if (GeneralUtil.isSuperUser(user)) {
            return;
        }
        new PermittedSpacesScope(this.spaceManager).restrictQuery(user, query);
    }

    public boolean isMailIncluded() {
        return CONTENT_ALL.equals(this.getType()) || "mail".equals(this.getType());
    }

    public String getIgnoredSearchWords() {
        return this.getSearchWordsLister().getIgnoredWordsAsString();
    }

    public String getSearchWords() {
        return this.getSearchWordsLister().getSearchWordsAsString();
    }

    public SearchWordsLister getSearchWordsLister() {
        if (this.searchWordsLister == null) {
            this.updateSearchWordsLister(this.queryString);
        }
        return this.searchWordsLister;
    }

    public void setSearchWordsLister(SearchWordsLister searchWordsLister) {
        this.searchWordsLister = searchWordsLister;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) throws IOException {
        this.updateSearchWordsLister(queryString);
        this.queryString = queryString;
    }

    public String getSpaceKey() {
        return this.spaceKey;
    }

    public void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    public String getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(String groupBy) {
        this.groupBy = groupBy;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTypeClass() {
        return SearchQueryBean.getTypeClass(this.getType());
    }

    public String getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(String lastModified) {
        this.lastModified = lastModified;
    }

    public void setSearcher(Searcher searcher) {
        this.searcher = searcher;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    public void setTimer(Timer timer) {
        this.timer = timer;
    }

    public String toString() {
        return "SearchQueryBean{searcher=" + this.searcher + ", spaceManager=" + this.spaceManager + ", userAccessor=" + this.userAccessor + ", spaceManager=" + this.spaceManager + ", queryString='" + this.queryString + '\'' + ", spaceKey='" + this.spaceKey + '\'' + ", type='" + this.type + '\'' + ", groupBy='" + this.groupBy + '\'' + ", lastModified='" + this.lastModified + '\'' + ", searchWordsLister=" + this.searchWordsLister + '}';
    }

    public void setLabelManager(LabelManager labelManager) {
        this.labelManager = labelManager;
    }

    public void setSpaceKeys(List spaceKeys) {
        this.spaceKeys = spaceKeys;
    }

    public void setSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    static {
        TYPE_MAP.put("page", Page.class.getName());
        TYPE_MAP.put("comment", Comment.class.getName());
        TYPE_MAP.put("blogpost", BlogPost.class.getName());
        TYPE_MAP.put("attachment", Attachment.class.getName());
        TYPE_MAP.put("userinfo", PersonalInformation.class.getName());
        TYPE_MAP.put("spacedesc", SpaceDescription.class.getName());
        TYPE_MAP.put("personalspacedesc", SpaceDescription.class.getName());
        TYPE_MAP.put("mail", Mail.class.getName());
    }
}

