/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.actions;

import bucket.core.actions.PaginationSupport;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.search.SpacePickerHelper;
import com.atlassian.confluence.search.actions.SearchBean;
import com.atlassian.confluence.search.actions.Timer;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.search.service.DateRangeEnum;
import com.atlassian.confluence.search.service.SearchQueryParameters;
import com.atlassian.confluence.search.service.SearchService;
import com.atlassian.confluence.search.service.SpaceCategoryEnum;
import com.atlassian.confluence.search.v2.BooleanOperator;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.search.v2.Search;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchResult;
import com.atlassian.confluence.search.v2.SearchResults;
import com.atlassian.confluence.search.v2.filter.SubsetResultFilter;
import com.atlassian.confluence.search.v2.lucene.LuceneSearchMapper;
import com.atlassian.confluence.search.v2.query.BooleanQuery;
import com.atlassian.confluence.search.v2.query.ContentTypeQuery;
import com.atlassian.confluence.search.v2.query.DateRangeQuery;
import com.atlassian.confluence.search.v2.query.TextFieldQuery;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.LabelUtil;
import com.atlassian.core.util.PairType;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchSiteAction
extends ConfluenceActionSupport {
    private static final Logger log = Logger.getLogger(SearchSiteAction.class);
    private static final Pattern QUERY_SPLIT_REGEX = Pattern.compile("\\s+(?:and\\s+|or\\s+)?");
    private static Timer timer = new Timer();
    private SearchBean searchBean;
    private SpacePickerHelper spacePickerHelper;
    private PaginationSupport paginationSupport;
    private SearchManager searchManager;
    private SearchService searchService;
    private SpaceManager spaceManager;
    private LuceneSearchMapper searchMapper;
    private int startIndex;
    private List<SearchResult> results;
    private UserDetails validatedContributor;
    private String queryString;
    private String where;
    private String type;
    private String contributor;
    private String contributorUsername;
    private DateRangeEnum lastModified;
    private static final int MAX_RESULTS_PER_PAGE = 10;
    private int totalSearchResults;
    private List<String> searchWords = Collections.emptyList();
    private BackwardsCompatibility searchQuery = new BackwardsCompatibility();
    private final List<PairType> types = new ArrayList<PairType>(9);
    private final List<PairType> dateRanges = new ArrayList<PairType>(5);
    private List relatedLabels;
    private static final int MAX_RELATED_LABELS_TO_DISPLAY = 10;
    private static final Pattern WORD_PATTERN = Pattern.compile("[\\w]+");
    private static final String AUTOCOMPLETE_USER_DETAILS_FORMAT = "{0} ({1})";

    public SearchSiteAction() {
        this.paginationSupport = new PaginationSupport(10);
    }

    public void validate() {
        super.validate();
        timer.start("Query validation");
        if (StringUtils.isBlank((String)this.queryString)) {
            return;
        }
        if (this.queryString.startsWith("*")) {
            this.addFieldError("queryString", this.getText("error.star.cannot.lead"));
        } else {
            try {
                this.searchMapper.convertToLuceneQuery(new TextFieldQuery("contentBody", this.queryString, BooleanOperator.AND));
            }
            catch (IllegalArgumentException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Error parsing query.", (Throwable)e);
                }
                this.addFieldError("queryString", this.getText("error.invalid.search.term"));
            }
        }
        if (StringUtils.isNotBlank((String)this.contributorUsername)) {
            this.validatedContributor = StringUtils.isNotBlank((String)this.contributor) ? new UserDetails(this.contributorUsername, this.contributor) : new UserDetails(this.contributorUsername);
        } else if (StringUtils.isNotBlank((String)this.contributor)) {
            List<UserDetails> contributors = this.getContributors(this.contributor);
            if (contributors.isEmpty()) {
                this.addFieldError("contributor", this.getText("error.invalid.search.nouser"));
            } else if (contributors.size() > 1) {
                this.addFieldError("contributor", this.getText("error.invalid.search.multipleusers"));
            } else {
                this.validatedContributor = contributors.get(0);
            }
        }
        timer.stop("Query validation");
    }

    public String execute() throws Exception {
        if (StringUtils.isBlank((String)this.queryString)) {
            return "success";
        }
        SearchQueryParameters params = new SearchQueryParameters(this.queryString);
        Object spaceKeys = null;
        SpaceCategoryEnum spaceCategory = SpaceCategoryEnum.get(this.where);
        params.setCategory(spaceCategory);
        if (spaceCategory == null && this.where != null) {
            params.setSpaceKey(this.where);
        }
        DateRangeQuery.DateRange lastModifiedRange = this.lastModified != null ? this.lastModified.dateRange() : null;
        params.setLastModified(lastModifiedRange);
        ContentTypeEnum contentType = null;
        if (StringUtils.isNotBlank((String)this.type)) {
            contentType = this.getContentType();
            if (contentType == null) {
                log.warn((Object)("Unknown type (" + this.type + ") was specified in the search. ContentType will be ignored."));
            } else {
                params.setContentType(contentType);
            }
        }
        if (this.validatedContributor != null) {
            params.setContributor(this.validatedContributor.getUsername());
            this.setContributor(this.validatedContributor.getFormattedName());
            this.setContributorUsername(this.validatedContributor.getUsername());
        }
        timer.start("Search");
        SearchResults searchResults = this.searchService.search(params, this.startIndex, 10);
        timer.stop("Search");
        if (searchResults == null) {
            log.warn((Object)("Failure executing search for term " + this.queryString));
            return "error";
        }
        this.totalSearchResults = searchResults.getUnfilteredResultsCount();
        this.searchWords = searchResults.getSearchWords();
        this.paginationSupport.setTotal(this.totalSearchResults);
        this.paginationSupport.setStartIndex(this.startIndex);
        this.results = searchResults.getAll();
        return "success";
    }

    private List<UserDetails> getContributors(String rawUserQuery) {
        UserDetails exactMatchDetails = this.exactUsernameSearch(rawUserQuery);
        if (exactMatchDetails != null) {
            return Collections.singletonList(exactMatchDetails);
        }
        Matcher m = WORD_PATTERN.matcher(rawUserQuery);
        String userQuery = "";
        while (m.find()) {
            String match = m.group();
            userQuery = userQuery + match + " ";
        }
        SearchResults searchResults = this.searchService.searchUsers(userQuery, 10);
        this.results = searchResults.getAll();
        ArrayList<UserDetails> result = new ArrayList<UserDetails>(this.results.size());
        for (SearchResult searchResult : this.results) {
            String username = searchResult.getExtraFields().get("username");
            String fullName = searchResult.getExtraFields().get("fullName");
            if (!StringUtils.isNotBlank((String)username) || !StringUtils.isNotBlank((String)fullName)) continue;
            UserDetails userDetails = new UserDetails(username, MessageFormat.format(AUTOCOMPLETE_USER_DETAILS_FORMAT, fullName, username));
            result.add(userDetails);
        }
        return result;
    }

    private UserDetails exactUsernameSearch(String username) {
        TextFieldQuery usernameFieldQuery = new TextFieldQuery("username", username, BooleanOperator.AND);
        ContentTypeQuery personalInformationQuery = new ContentTypeQuery(ContentTypeEnum.PERSONAL_INFORMATION);
        SearchQuery andQuery = BooleanQuery.composeAndQuery(personalInformationQuery, usernameFieldQuery);
        UserDetails userDetails = null;
        try {
            SearchResults results = this.searchManager.search(new Search(andQuery, null, null, new SubsetResultFilter(0, 1)));
            Iterator<SearchResult> it = results.iterator();
            if (it.hasNext()) {
                SearchResult result = it.next();
                String fullname = result.getExtraFields().get("fullName");
                userDetails = StringUtils.isNotBlank((String)fullname) ? new UserDetails(username, MessageFormat.format(AUTOCOMPLETE_USER_DETAILS_FORMAT, fullname, username)) : new UserDetails(username);
            } else {
                log.debug((Object)("No PersonalInformation found in the index for username " + username));
            }
        }
        catch (InvalidSearchException ex) {
            log.warn((Object)("Failure during search for username " + username), (Throwable)ex);
        }
        return userDetails;
    }

    public List<SearchResult> getResults() {
        return this.results;
    }

    public List getAvailableSpaces() {
        return this.getSpacePickerHelper().getAvailableSpaces(this.getRemoteUser());
    }

    public List getAvailableGlobalSpaces() {
        return this.getSpacePickerHelper().getAvailableGlobalSpaces(this.getRemoteUser());
    }

    public List getAggregateOptions() {
        return this.getSpacePickerHelper().getAggregateOptions(this);
    }

    public List getFavouriteSpaces() {
        return this.getSpacePickerHelper().getFavouriteSpaces(this.getRemoteUser());
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    private SpacePickerHelper getSpacePickerHelper() {
        if (this.spacePickerHelper == null) {
            this.spacePickerHelper = new SpacePickerHelper(this.spaceManager, this.labelManager);
        }
        return this.spacePickerHelper;
    }

    public List<PairType> getContentEntityTypes() {
        ArrayList<PairType> result = new ArrayList<PairType>(7);
        result.add(new PairType((Serializable)((Object)"page"), (Serializable)((Object)this.getText("type.pages"))));
        result.add(new PairType((Serializable)((Object)"blogpost"), (Serializable)((Object)this.getText("type.newsitems"))));
        result.add(new PairType((Serializable)((Object)"mail"), (Serializable)((Object)this.getText("type.mail"))));
        result.add(new PairType((Serializable)((Object)"comment"), (Serializable)((Object)this.getText("type.comments"))));
        result.add(new PairType((Serializable)((Object)"attachment"), (Serializable)((Object)this.getText("type.attachments"))));
        if (!this.settingsManager.getGlobalSettings().isSharedMode()) {
            result.add(new PairType((Serializable)((Object)"userinfo"), (Serializable)((Object)this.getText("type.profiles"))));
        }
        result.add(new PairType((Serializable)((Object)"spacedesc"), (Serializable)((Object)this.getText("type.space.desc"))));
        return result;
    }

    private List getMatchingLabels() {
        Set<String> unparsedLabelNames = SearchSiteAction.splitSearchToLabels(this.queryString);
        return this.labelManager.getLabels(unparsedLabelNames);
    }

    public List getRelatedLabels() {
        if (this.relatedLabels == null) {
            this.relatedLabels = new ArrayList();
            List matchingLabels = this.getMatchingLabels();
            this.relatedLabels.addAll(matchingLabels);
            this.relatedLabels.addAll(this.labelManager.getRelatedLabels(matchingLabels, null, 5));
            this.relatedLabels = this.relatedLabels.subList(0, Math.min(this.relatedLabels.size(), 10));
        }
        return this.relatedLabels;
    }

    public String getLabelNames(Labelable obj) {
        return LabelUtil.convertToDelimitedString(obj, this.getRemoteUser());
    }

    public List getContentLabels(ContentEntityObject content, int amount) {
        List labels = content.getLabels();
        if (labels.size() < amount) {
            return labels;
        }
        return labels.subList(0, amount);
    }

    public Space getSpace(String spaceKey) {
        return this.spaceManager.getSpace(spaceKey);
    }

    public SearchBean getSearchBean() {
        return this.searchBean;
    }

    public void setSearchBean(SearchBean searchBean) {
        this.searchBean = searchBean;
    }

    public String getTypeName(String type) {
        for (PairType pairType : this.getContentEntityTypes()) {
            if (!type.equals(pairType.getKey())) continue;
            return pairType.getValue().toString().toLowerCase();
        }
        return "";
    }

    public List<PairType> getTypes() {
        this.types.add(new PairType(null, (Serializable)((Object)this.getText("type.allcontent"))));
        this.types.add(new PairType((Serializable)((Object)ContentTypeEnum.PAGE.getRepresentation()), (Serializable)((Object)this.getText("type.pages"))));
        this.types.add(new PairType((Serializable)((Object)ContentTypeEnum.BLOG.getRepresentation()), (Serializable)((Object)this.getText("type.newsitems"))));
        this.types.add(new PairType((Serializable)((Object)ContentTypeEnum.MAIL.getRepresentation()), (Serializable)((Object)this.getText("type.mail"))));
        this.types.add(new PairType((Serializable)((Object)ContentTypeEnum.COMMENT.getRepresentation()), (Serializable)((Object)this.getText("type.comments"))));
        this.types.add(new PairType((Serializable)((Object)ContentTypeEnum.ATTACHMENT.getRepresentation()), (Serializable)((Object)this.getText("type.attachments"))));
        if (!this.settingsManager.getGlobalSettings().isSharedMode()) {
            this.types.add(new PairType((Serializable)((Object)ContentTypeEnum.PERSONAL_INFORMATION.getRepresentation()), (Serializable)((Object)this.getText("type.profiles"))));
        }
        this.types.add(new PairType((Serializable)((Object)ContentTypeEnum.SPACE_DESCRIPTION.getRepresentation()), (Serializable)((Object)this.getText("type.space.desc"))));
        return this.types;
    }

    public List<PairType> getDateRanges() {
        this.dateRanges.add(new PairType(null, (Serializable)((Object)this.getText("modified.any.date"))));
        this.dateRanges.add(new PairType((Serializable)((Object)DateRangeEnum.TODAY), (Serializable)((Object)this.getText("modified.today"))));
        this.dateRanges.add(new PairType((Serializable)((Object)DateRangeEnum.YESTERDAY), (Serializable)((Object)this.getText("modified.yesterday"))));
        this.dateRanges.add(new PairType((Serializable)((Object)DateRangeEnum.LASTWEEK), (Serializable)((Object)this.getText("modified.lastweek"))));
        this.dateRanges.add(new PairType((Serializable)((Object)DateRangeEnum.LASTMONTH), (Serializable)((Object)this.getText("modified.lastmonth"))));
        return this.dateRanges;
    }

    public void setSearchService(SearchService service) {
        this.searchService = service;
    }

    @Override
    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    public CriteriaParameters getCurrentSearch() {
        return new CriteriaParameters(null, this.queryString, this.where, this.getContentType(), this.lastModified, this.contributor, this.contributorUsername);
    }

    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getEndIndex() {
        return Math.min(this.startIndex + 10, this.totalSearchResults);
    }

    public Timer getTimer() {
        return timer;
    }

    static Set<String> splitSearchToLabels(String queryStr) {
        if (StringUtils.isBlank((String)queryStr)) {
            return Collections.emptySet();
        }
        String[] terms = QUERY_SPLIT_REGEX.split(queryStr.toLowerCase());
        HashSet<String> uniqueTerms = new HashSet<String>(terms.length);
        uniqueTerms.addAll(Arrays.asList(terms));
        return uniqueTerms;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public String getWhere() {
        return this.where;
    }

    public void setWhere(String where) {
        this.where = where;
    }

    public String getType() {
        return this.type;
    }

    public ContentTypeEnum getContentType() {
        return ContentTypeEnum.get(this.type);
    }

    public void setType(String type) {
        this.type = type;
    }

    public DateRangeEnum getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(DateRangeEnum lastModified) {
        this.lastModified = lastModified;
    }

    public int getTotalSearchResults() {
        return this.totalSearchResults;
    }

    public PaginationSupport getPaginationSupport() {
        return this.paginationSupport;
    }

    public void setSearchMapper(LuceneSearchMapper searchMapper) {
        this.searchMapper = searchMapper;
    }

    public void setSearchManager(SearchManager searchManager) {
        this.searchManager = searchManager;
    }

    public List<String> getSearchWords() {
        return this.searchWords;
    }

    public BackwardsCompatibility getSearchQuery() {
        return this.searchQuery;
    }

    public void setContributor(String who) {
        this.contributor = who;
    }

    public String getContributor() {
        return this.contributor;
    }

    public String getContributorUsername() {
        return this.contributorUsername;
    }

    public void setContributorUsername(String contributorUsername) {
        this.contributorUsername = contributorUsername;
    }

    public static class UserDetails {
        private final String username;
        private final String formattedName;

        public UserDetails(String username, String formattedName) {
            this.username = username;
            this.formattedName = formattedName;
        }

        public UserDetails(String username) {
            this.username = username;
            this.formattedName = username;
        }

        public String getUsername() {
            return this.username;
        }

        public String getFormattedName() {
            return this.formattedName;
        }
    }

    public class BackwardsCompatibility {
        public void setQueryString(String queryString) {
            SearchSiteAction.this.queryString = queryString;
        }

        public void setSpaceKey(String spaceKey) {
            SearchSiteAction.this.where = spaceKey;
        }

        public void setType(String type) {
            SearchSiteAction.this.type = type;
        }

        public void setLastModified(String lastModified) {
            SearchSiteAction.this.lastModified = StringUtils.isBlank((String)lastModified) ? null : DateRangeEnum.valueOf(lastModified.toUpperCase());
        }
    }

    public static class CriteriaParameters {
        private String queryString;
        private String spaceKey;
        private ContentTypeEnum type;
        private DateRangeEnum lastModified;
        private String contributor;
        private String contributorUsername;
        private String labelKey;

        public CriteriaParameters(String labelKey, String queryString, String spaceKey, ContentTypeEnum type, DateRangeEnum lastModified, String contributor, String contributorUsername) {
            this.labelKey = labelKey;
            this.queryString = queryString;
            this.spaceKey = spaceKey;
            this.type = type;
            this.lastModified = lastModified;
            this.contributor = contributor;
            this.contributorUsername = contributorUsername;
        }

        public String getQueryParameters() {
            StringBuffer result = new StringBuffer();
            if (StringUtils.isNotBlank((String)this.queryString)) {
                result.append("&").append("queryString=").append(GeneralUtil.urlEncode(this.queryString));
            }
            if (StringUtils.isNotBlank((String)this.spaceKey)) {
                result.append("&").append("where=").append(GeneralUtil.urlEncode(this.spaceKey));
            } else {
                result.append("&").append("where=").append(GeneralUtil.urlEncode(SpaceCategoryEnum.ALL.getRepresentation()));
            }
            if (this.type != null) {
                result.append("&").append("type=").append(GeneralUtil.urlEncode(this.type.getRepresentation()));
            }
            if (this.lastModified != null) {
                result.append("&").append("lastModified=").append(GeneralUtil.urlEncode(this.lastModified.name()));
            }
            if (StringUtils.isNotBlank((String)this.contributor)) {
                result.append("&").append("contributor=").append(GeneralUtil.urlEncode(this.contributor));
            }
            if (StringUtils.isNotBlank((String)this.contributorUsername)) {
                result.append("&").append("contributorUsername=").append(GeneralUtil.urlEncode(this.contributorUsername));
            }
            return result.toString().substring(1);
        }

        public String getLabelKey() {
            return this.labelKey;
        }

        public String getSpaceKey() {
            return this.spaceKey;
        }

        public ContentTypeEnum getType() {
            return this.type;
        }

        public DateRangeEnum getLastModified() {
            return this.lastModified;
        }

        public String getQueryString() {
            return this.queryString;
        }

        public String getContributor() {
            return this.contributor;
        }

        public String getContributorUsername() {
            return this.contributorUsername;
        }
    }
}

