/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.actions;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.json.JSONAction;
import com.atlassian.confluence.json.JSONArray;
import com.atlassian.confluence.json.JSONException;
import com.atlassian.confluence.json.JSONObject;
import com.atlassian.confluence.search.service.SearchService;
import com.atlassian.confluence.search.v2.SearchResult;
import com.atlassian.confluence.search.v2.SearchResults;
import com.atlassian.confluence.util.GeneralUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class UserSearchAction
extends ConfluenceActionSupport
implements JSONAction {
    SearchService searchService;
    private String query;
    private static final int MAX_RESULTS = 6;
    private List<SearchResult> results;
    private static final SearchResultComparator COMPARATOR = new SearchResultComparator();

    public String execute() throws Exception {
        try {
            SearchResults searchResults = this.searchService.searchUsers(this.query, 6);
            this.results = searchResults.getAll();
        }
        catch (IllegalArgumentException e) {
            this.results = Collections.emptyList();
        }
        return "success";
    }

    public String getJSONString() throws JSONException {
        JSONArray array = new JSONArray();
        if (this.results.isEmpty()) {
            array.put(new JSONObject().put("status", this.getText("usersearch.no.results")));
        }
        int upperBound = Math.min(this.results.size(), 6);
        ArrayList<SearchResult> resultSubset = new ArrayList<SearchResult>(upperBound);
        for (int i = 0; i < upperBound; ++i) {
            resultSubset.add(this.results.get(i));
        }
        Collections.sort(resultSubset, COMPARATOR);
        for (SearchResult searchResult : resultSubset) {
            array.put(new JSONObject().put("username", GeneralUtil.htmlEncode(searchResult.getExtraFields().get("username"))).put("fullName", GeneralUtil.htmlEncode(searchResult.getExtraFields().get("fullName"))));
        }
        return array.toString();
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SearchResultComparator
    implements Comparator<SearchResult> {
        SearchResultComparator() {
        }

        @Override
        public int compare(SearchResult sr1, SearchResult sr2) {
            String fullname1 = sr1.getExtraFields().get("fullName");
            String fullname2 = sr2.getExtraFields().get("fullName");
            if (StringUtils.isBlank((String)fullname1) && StringUtils.isNotBlank((String)fullname2)) {
                return 1;
            }
            if (StringUtils.isBlank((String)fullname2) && StringUtils.isNotBlank((String)fullname1)) {
                return -1;
            }
            if (StringUtils.isBlank((String)fullname1) && StringUtils.isBlank((String)fullname2)) {
                return 0;
            }
            return fullname1.compareTo(fullname2);
        }
    }
}

