/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.lucene;

import com.atlassian.bonnie.LuceneConnection;
import com.atlassian.bonnie.analyzer.LuceneAnalyzerFactory;
import com.atlassian.bonnie.search.SinceDateQueryFactory;
import com.atlassian.confluence.setup.BootstrapManager;
import com.opensymphony.util.TextUtils;
import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DateFilterScoringSearcher;
import org.apache.lucene.search.DefaultSimilarity;
import org.apache.lucene.search.DelayCloseIndexSearcher;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Sort;

public class ConfluenceLuceneConnection
extends LuceneConnection {
    protected static Logger log = Logger.getLogger(ConfluenceLuceneConnection.class);
    private String tmpDir;
    private BootstrapManager bootstrapManager;
    private DelayCloseIndexSearcher currentSearcher;
    private static final Pattern LUCENE_SORT_ERROR_PATTERN = Pattern.compile("field \"\\w+\" does not appear to be indexed");

    public ConfluenceLuceneConnection() {
    }

    public ConfluenceLuceneConnection(LuceneAnalyzerFactory analyzerFactory, BootstrapManager bootstrapManager) {
        super((File)null, analyzerFactory.createIndexingAnalyzer());
        this.bootstrapManager = bootstrapManager;
    }

    public void setBootstrapManager(BootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    public File getIndexDir() {
        if (super.getIndexDir() == null) {
            this.setIndexDir(this.bootstrapManager.getFilePathProperty("lucene.index.dir"));
        }
        return super.getIndexDir();
    }

    public boolean isSearcherCurrent() throws IOException {
        return this.getCurrentSearcher().isCurrent();
    }

    protected IndexSearcher getSearcher() throws IOException {
        DelayCloseIndexSearcher currentSearcher = this.getCurrentSearcher();
        currentSearcher.open();
        return currentSearcher;
    }

    private DelayCloseIndexSearcher createSearcher() throws IOException {
        DateFilterScoringSearcher searcher = new DateFilterScoringSearcher(this.getDirectory());
        searcher.setSimilarity((Similarity)new DefaultSimilarity(){

            public float idf(Term term, Searcher searcher) throws IOException {
                String field = term.field();
                if ("label".equals(field) || "modified".equals(field) || "userpermission".equals(field) || "classname".equals(field)) {
                    return 1.0f;
                }
                return super.idf(term, searcher);
            }
        });
        if (log.isDebugEnabled()) {
            log.debug((Object)"Warming up searcher..");
        }
        Sort sort = new Sort("modified");
        try {
            BooleanQuery q = (BooleanQuery)new QueryParser("", (Analyzer)new StandardAnalyzer()).parse("+(((title:overview from:overview)^9.0) labelText:overview^9.0 content:overview^5.0 (username:overview fullName:overview filename:overview recipients:overview)) -classname:com.atlassian.confluence.mail.Mail");
            q.add(SinceDateQueryFactory.getInstance((String)"lastmonth", (String)"modified").toQuery(), BooleanClause.Occur.MUST);
            searcher.search((Query)q, null, -1, sort);
        }
        catch (Throwable e) {
            if ("no terms in field modified - cannot determine sort type".equalsIgnoreCase(e.getMessage())) {
                log.info((Object)"Error encountered - most likely empty index", e);
            }
            if (LUCENE_SORT_ERROR_PATTERN.matcher(TextUtils.noNull((String)e.getMessage())).matches()) {
                log.debug((Object)"Error encountered - no documents in the index contain the sort field.", e);
            }
            log.error((Object)("Error encountered: " + e.getMessage()), e);
        }
        return searcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshSearcher() throws IOException {
        if (this.isReIndexing()) {
            log.info((Object)"Not refreshing searcher because reindexing is in progress.");
        } else {
            DelayCloseIndexSearcher old;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Refreshing searcher..");
            }
            DelayCloseIndexSearcher searcher = this.createSearcher();
            ConfluenceLuceneConnection confluenceLuceneConnection = this;
            synchronized (confluenceLuceneConnection) {
                old = this.currentSearcher;
                this.currentSearcher = searcher;
            }
            if (old != null) {
                old.closeWhenDone();
            }
        }
    }

    private synchronized DelayCloseIndexSearcher getCurrentSearcher() throws IOException {
        if (this.currentSearcher == null) {
            this.currentSearcher = this.createSearcher();
        }
        return this.currentSearcher;
    }

    public String getTmpDir() {
        if (this.tmpDir == null) {
            this.setTmpDir(this.bootstrapManager.getFilePathProperty("webwork.multipart.saveDir"));
        }
        return this.tmpDir;
    }

    public void setTmpDir(String tmpDir) {
        this.tmpDir = tmpDir;
    }
}

