/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.lucene;

import bucket.core.persistence.hibernate.AnyTypeHibernateObjectDao;
import bucket.core.persistence.hibernate.HibernateHandle;
import com.atlassian.bonnie.index.BatchOpIndexer;
import com.atlassian.bonnie.index.ObjectQueue;
import com.atlassian.confluence.search.lucene.ConfluenceObjectToDocumentConverter;
import com.atlassian.spring.container.ContainerManager;
import com.opensymphony.util.TextUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.apache.log4j.Logger;
import org.springframework.orm.hibernate.SessionFactoryUtils;

public class ConfluenceObjectQueue
implements ObjectQueue {
    private static Logger log = Logger.getLogger(ConfluenceObjectQueue.class);
    private List handles;
    private SessionFactory sessionFactory;

    public ConfluenceObjectQueue(List handles, SessionFactory sessionFactory) {
        this.handles = handles;
        Collections.shuffle(this.handles);
        this.sessionFactory = sessionFactory;
    }

    public Collection pop() {
        LinkedList<Object> idsToCollect = new LinkedList<Object>();
        String className = null;
        Iterator it = this.handles.iterator();
        while (it.hasNext() && idsToCollect.size() < 10) {
            HibernateHandle handle = (HibernateHandle)it.next();
            if (className != null && !className.equals(handle.getClassName())) continue;
            className = handle.getClassName();
            idsToCollect.add(new Long(handle.getId()));
            it.remove();
        }
        if (idsToCollect.size() > 0) {
            idsToCollect.add(className);
        }
        return idsToCollect;
    }

    public boolean hasMore() {
        return this.handles.size() > 0;
    }

    public int size() {
        return this.handles.size();
    }

    public ObjectQueue.Processor getProcessor() {
        return new ObjectQueue.Processor(){
            ConfluenceObjectToDocumentConverter otdc = (ConfluenceObjectToDocumentConverter)ContainerManager.getComponent((String)"objectToDocumentConverter");

            public void indexCollection(Collection collection, BatchOpIndexer.DocumentWritingScheme documentWritingScheme) {
                try {
                    List handles = (List)collection;
                    if (handles.size() > 0) {
                        String className = (String)handles.remove(handles.size() - 1);
                        List list = this.getObjects(handles, className);
                        Iterator it = list.iterator();
                        while (it.hasNext()) {
                            try {
                                documentWritingScheme.write(this.otdc.convert(it.next(), null));
                            }
                            catch (Throwable t) {
                                log.error((Object)"Error indexing document", t);
                            }
                        }
                    }
                }
                catch (HibernateException e) {
                    AnyTypeHibernateObjectDao.log.error((Object)("Unable to get objects: " + e.getMessage()), (Throwable)e);
                }
            }

            private List getObjects(List idsToCollect, String className) throws HibernateException {
                Session session = SessionFactoryUtils.getSession((SessionFactory)ConfluenceObjectQueue.this.sessionFactory, (boolean)false);
                session.clear();
                return session.find("from " + className + " s where s.id = " + TextUtils.join((String)" or s.id = ", (Collection)idsToCollect));
            }
        };
    }
}

