/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.lucene;

import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.Tokenizer;

public final class CustomJapaneseTokenizer
extends Tokenizer {
    private static final int MAX_WORD_LEN = 255;
    private static final int IO_BUFFER_SIZE = 256;
    private int offset = 0;
    private int bufferIndex = 0;
    private int dataLen = 0;
    private final char[] buffer = new char[255];
    private final char[] ioBuffer = new char[256];
    private String tokenType = "word";
    private boolean preIsTokened = false;
    private static Method normalizerMethod = null;
    private static Object normalizeMode;
    private static boolean version6;

    public CustomJapaneseTokenizer(Reader in) {
        this.input = in;
    }

    public final Token next() throws IOException {
        int length = 0;
        int start = this.offset;
        while (true) {
            char c;
            Character.UnicodeBlock ub;
            ++this.offset;
            if (this.bufferIndex >= this.dataLen) {
                this.dataLen = this.input.read(this.ioBuffer);
                this.bufferIndex = 0;
            }
            if (this.dataLen == -1) {
                if (length > 0) {
                    if (!this.preIsTokened) break;
                    length = 0;
                    this.preIsTokened = false;
                    break;
                }
                return null;
            }
            if ((ub = Character.UnicodeBlock.of(c = this.ioBuffer[this.bufferIndex++])) == Character.UnicodeBlock.BASIC_LATIN || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS) {
                if (ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS) {
                    c = this.normalizeCharacterIfPossible(c);
                }
                if (Character.isLetterOrDigit(c) || c == '_' || c == '+' || c == '#') {
                    if (length == 0) {
                        start = this.offset - 1;
                    } else if (this.tokenType == "double") {
                        --this.offset;
                        --this.bufferIndex;
                        this.tokenType = "single";
                        if (!this.preIsTokened) break;
                        length = 0;
                        this.preIsTokened = false;
                        break;
                    }
                    this.buffer[length++] = Character.toLowerCase(c);
                    this.tokenType = "single";
                    if (length != 255) continue;
                    break;
                }
                if (length <= 0) continue;
                if (!this.preIsTokened) break;
                length = 0;
                this.preIsTokened = false;
                continue;
            }
            if (Character.isLetter(c)) {
                if (length == 0) {
                    start = this.offset - 1;
                    this.buffer[length++] = c;
                    this.tokenType = "double";
                    continue;
                }
                if (this.tokenType == "single") {
                    --this.offset;
                    --this.bufferIndex;
                    break;
                }
                this.buffer[length++] = c;
                this.tokenType = "double";
                if (length != 2) continue;
                --this.offset;
                --this.bufferIndex;
                this.preIsTokened = true;
                break;
            }
            if (length <= 0) continue;
            if (!this.preIsTokened) break;
            length = 0;
            this.preIsTokened = false;
        }
        return new Token(new String(this.buffer, 0, length), start, start + length, this.tokenType);
    }

    private char normalizeCharacterIfPossible(char c) {
        String wrapper = new String(new char[]{c});
        if (normalizerMethod != null) {
            String result;
            try {
                result = version6 ? (String)normalizerMethod.invoke(null, wrapper, ((Field)normalizeMode).get(null)) : (String)normalizerMethod.invoke(null, wrapper, normalizeMode, new Integer(0));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            c = result.charAt(0);
        } else {
            int i = c;
            c = (char)(i -= 65248);
        }
        return (char)c;
    }

    static {
        version6 = false;
        try {
            Class<?> normalizer = Class.forName("sun.text.Normalizer");
            Class<?> mode = Class.forName("sun.text.Normalizer$Mode");
            Field normalizeModeField = normalizer.getField("DECOMP_COMPAT");
            normalizeMode = normalizeModeField.get(null);
            normalizerMethod = normalizer.getMethod("normalize", String.class, mode, Integer.TYPE);
        }
        catch (Exception e) {
            try {
                Class<?> normalizer = Class.forName("java.text.Normalizer");
                Class<?> mode = Class.forName("java.text.Normalizer$Form");
                normalizeMode = mode.getFields()[2];
                normalizerMethod = normalizer.getMethods()[0];
                version6 = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

