/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.lucene;

import com.atlassian.bonnie.AnyTypeObjectDao;
import com.atlassian.bonnie.Handle;
import com.atlassian.bonnie.analyzer.LuceneAnalyzerFactory;
import com.atlassian.bonnie.index.BatchOpIndexer;
import com.atlassian.bonnie.index.ObjectQueue;
import com.atlassian.bonnie.index.TempDirectoryDocumentWritingScheme;
import com.atlassian.confluence.event.events.admin.ReindexFinishedEvent;
import com.atlassian.confluence.event.events.admin.ReindexStartedEvent;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.search.IndexingTask;
import com.atlassian.confluence.search.lucene.ConfluenceBatchIndexer;
import com.atlassian.confluence.search.lucene.ConfluenceLuceneConnection;
import com.atlassian.confluence.search.lucene.ConfluenceObjectQueue;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.user.PersonalInformation;
import com.atlassian.core.util.ProgressMeter;
import com.atlassian.event.Event;
import com.atlassian.event.EventManager;
import com.atlassian.spring.container.ContainerManager;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import net.sf.hibernate.SessionFactory;
import org.apache.log4j.Category;

public class DefaultConfluenceBatchIndexer
implements ConfluenceBatchIndexer {
    public static final Category LOG = Category.getInstance(DefaultConfluenceBatchIndexer.class);
    private IndexingTask reindexTask;
    private EventManager eventManager;
    protected BatchOpIndexer multiIndexer;
    protected LuceneAnalyzerFactory analyzerFactory;
    protected AnyTypeObjectDao anyTypeObjectDao;
    private SessionFactory sessionFactory;
    private BootstrapManager bootstrapManager;
    private ConfluenceLuceneConnection luceneConnection;
    private static final String REINDEXING_THREAD_NAME = "confluence-batch-reindexing-thread";

    public void reIndexAll() {
        ConfluenceBatchIndexer springWrappedThis = (ConfluenceBatchIndexer)ContainerManager.getComponent((String)"confluenceBatchIndexer");
        this.reindexTask = new IndexingTask(springWrappedThis);
        Thread reindexingThread = new Thread((Runnable)((Object)this.reindexTask));
        reindexingThread.setName(REINDEXING_THREAD_NAME);
        reindexingThread.start();
    }

    public void indexEntities(ProgressMeter progress) {
        if (this.multiIndexer == null) {
            return;
        }
        this.eventManager.publishEvent((Event)new ReindexStartedEvent(this));
        try {
            this.multiIndexer.truncateIndex();
        }
        catch (IOException e) {
            LOG.error((Object)"Error occured truncating existing index.", (Throwable)e);
        }
        progress.setStatus("Loading objects to index...");
        List handles = this.getEntityHandles();
        try {
            File tempDir = new File(this.bootstrapManager.getFilePathProperty("webwork.multipart.saveDir"));
            if (!tempDir.exists()) {
                tempDir.mkdirs();
            }
            this.multiIndexer.reindex((ObjectQueue)new ConfluenceObjectQueue(handles, this.sessionFactory), (BatchOpIndexer.DocumentWritingScheme)new TempDirectoryDocumentWritingScheme(this.multiIndexer, tempDir.getPath()), progress, true);
        }
        catch (IOException e) {
            LOG.error((Object)"Error encountered", (Throwable)e);
        }
        this.refreshSearcher();
        progress.setPercentage(100);
        progress.setStatus("Finished reindexing " + progress.getTotal() + " objects.");
        this.eventManager.publishEvent((Event)new ReindexFinishedEvent(this));
    }

    protected List getEntityHandles() {
        List handles = this.anyTypeObjectDao.findAllSearchableObjectHandles();
        LinkedList<Handle> fixedHandles = new LinkedList<Handle>();
        for (Handle h : handles) {
            if (h.toString().startsWith(Attachment.class.getName()) || h.toString().startsWith(PersonalInformation.class.getName())) {
                fixedHandles.addLast(h);
                continue;
            }
            fixedHandles.addFirst(h);
        }
        return fixedHandles;
    }

    public void unIndexAll() {
        try {
            this.multiIndexer.truncateIndex();
        }
        catch (IOException e) {
            LOG.error((Object)"Failed to unIndexAll.", (Throwable)e);
        }
    }

    public boolean isReIndexRunning() {
        return this.getLastReindexingTask() != null && !this.getLastReindexingTask().isFinishedReindexing();
    }

    public IndexingTask getLastReindexingTask() {
        return this.reindexTask;
    }

    private void refreshSearcher() {
        try {
            if (!this.luceneConnection.isSearcherCurrent()) {
                this.luceneConnection.refreshSearcher();
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Failed to refresh the lucene searcher.", (Throwable)e);
        }
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    public void setMultiIndexer(BatchOpIndexer multiIndexer) {
        this.multiIndexer = multiIndexer;
    }

    public void setAnalyzerFactory(LuceneAnalyzerFactory analyzerFactory) {
        this.analyzerFactory = analyzerFactory;
    }

    public void setAnyTypeObjectDao(AnyTypeObjectDao anyTypeObjectDao) {
        this.anyTypeObjectDao = anyTypeObjectDao;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void setBootstrapManager(BootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    public void setLuceneConnection(ConfluenceLuceneConnection luceneConnection) {
        this.luceneConnection = luceneConnection;
    }
}

