/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.lucene;

import java.util.Date;

public class FlushStatistics {
    private Date started;
    private Date finished;
    private long queueSize;
    private boolean recreated;
    private boolean optimised;

    protected void reset() {
        this.started = null;
        this.finished = null;
        this.queueSize = 0L;
        this.recreated = false;
        this.optimised = false;
    }

    public long getElapsedMilliseconds() {
        if (this.started == null) {
            return 0L;
        }
        if (this.finished == null) {
            return System.currentTimeMillis() - this.started.getTime();
        }
        return this.finished.getTime() - this.started.getTime();
    }

    public long getQueueSize() {
        return this.queueSize;
    }

    public boolean wasRecreated() {
        return this.recreated;
    }

    public boolean wasOptimised() {
        return this.optimised;
    }

    public Date getStarted() {
        return this.started;
    }

    public void setStarted(Date started) {
        this.started = started;
    }

    public void setFinished(Date finished) {
        this.finished = finished;
    }

    public void setQueueSize(long queueSize) {
        this.queueSize = queueSize;
    }

    public void setRecreated(boolean recreated) {
        this.recreated = recreated;
    }

    public void setOptimised(boolean optimised) {
        this.optimised = optimised;
    }
}

