/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.lucene;

import com.atlassian.bonnie.Searchable;
import com.atlassian.bonnie.search.Extractor;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.Namespace;
import com.opensymphony.util.TextUtils;
import java.util.HashSet;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;

public class LabelExtractor
implements Extractor {
    public static final String LABEL_FIELD = "label";
    public static final String LABEL_TEXT_FIELD = "labelText";

    public void addFields(Document document, StringBuffer defaultSearchableText, Searchable searchable) {
        if (!(searchable instanceof ContentEntityObject)) {
            return;
        }
        ContentEntityObject content = (ContentEntityObject)searchable;
        HashSet<String> visibleLabels = new HashSet<String>();
        for (Label label : content.getLabels()) {
            if ("public".equals(label.getNamespace().getVisibility())) {
                visibleLabels.add(label.getName());
            }
            if (Namespace.PERSONAL.equals(label.getNamespace())) {
                document.add((Fieldable)new Field(LABEL_FIELD, label.toStringWithOwnerPrefix(), Field.Store.YES, Field.Index.UN_TOKENIZED));
                continue;
            }
            document.add((Fieldable)new Field(LABEL_FIELD, label.toStringWithNamespace(), Field.Store.YES, Field.Index.UN_TOKENIZED));
        }
        document.add((Fieldable)new Field(LABEL_TEXT_FIELD, TextUtils.join((String)" ", visibleLabels), Field.Store.YES, Field.Index.TOKENIZED));
    }
}

