/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.lucene.bonnie;

import com.atlassian.bonnie.ILuceneConnection;
import com.atlassian.confluence.search.lucene.DefaultConfluenceIndexManager;
import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.IndexReader;

public class BulkReaderAction
implements ILuceneConnection.ReaderAction {
    private final List deleteEntries;

    public BulkReaderAction(List deleteEntries) {
        this.deleteEntries = deleteEntries;
    }

    public Object perform(IndexReader reader) throws IOException {
        int deleted = 0;
        for (ILuceneConnection.ReaderAction task : this.deleteEntries) {
            if (DefaultConfluenceIndexManager.log.isDebugEnabled()) {
                DefaultConfluenceIndexManager.log.debug((Object)("Performing delete task: " + task));
            }
            task.perform(reader);
            ++deleted;
        }
        if (DefaultConfluenceIndexManager.log.isDebugEnabled()) {
            DefaultConfluenceIndexManager.log.debug((Object)(deleted + " documents deleted."));
        }
        return null;
    }

    public List getEntries() {
        return this.deleteEntries;
    }
}

