/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.lucene.extractor;

import com.atlassian.bonnie.Searchable;
import com.atlassian.bonnie.search.Extractor;
import com.atlassian.bonnie.search.extractor.AttachmentMetadataExtractor;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.user.PersonalInformation;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;

public class ConfluenceAttachmentMetadataExtractor
implements Extractor {
    private Extractor attachmentExtractor = new AttachmentMetadataExtractor();
    public static final String CONTENT_REAL_TITLE_FIELD = "content.realTitle";
    public static final String CONTENT_URL_PATH_FIELD = "content.urlPath";
    public static final String CONTENT_SPACE_NAME_FIELD = "content.space.name";

    public void addFields(Document document, StringBuffer defaultSearchableText, Searchable searchable) {
        if (searchable instanceof Attachment) {
            Attachment attachment = (Attachment)searchable;
            ContentEntityObject ceo = attachment.getContent();
            this.attachmentExtractor.addFields(document, defaultSearchableText, searchable);
            long fileSize = attachment.getFileSize();
            int intFileSize = fileSize >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)fileSize;
            document.add((Fieldable)new Field("filesize", Integer.toString(intFileSize), Field.Store.YES, Field.Index.UN_TOKENIZED));
            document.add((Fieldable)new Field("filenameuntokenized", attachment.getFileName(), Field.Store.YES, Field.Index.UN_TOKENIZED));
            document.add((Fieldable)new Field("file.extension", attachment.getFileExtension(), Field.Store.NO, Field.Index.UN_TOKENIZED));
            document.add((Fieldable)new Field("content.type", ceo.getType(), Field.Store.YES, Field.Index.NO));
            if (ceo instanceof PersonalInformation) {
                PersonalInformation pi = (PersonalInformation)ceo;
                document.add((Fieldable)new Field("content.username", pi.getUsername(), Field.Store.YES, Field.Index.NO));
            } else if (ceo instanceof SpaceContentEntityObject) {
                SpaceContentEntityObject sceo = (SpaceContentEntityObject)ceo;
                document.add((Fieldable)new Field(CONTENT_SPACE_NAME_FIELD, sceo.getSpace().getName(), Field.Store.YES, Field.Index.NO));
                document.add((Fieldable)new Field("content.space.key", sceo.getSpace().getKey(), Field.Store.YES, Field.Index.NO));
            }
            document.add((Fieldable)new Field(CONTENT_URL_PATH_FIELD, ceo.getUrlPath(), Field.Store.YES, Field.Index.NO));
            document.add((Fieldable)new Field(CONTENT_REAL_TITLE_FIELD, ceo.getDisplayTitle(), Field.Store.YES, Field.Index.NO));
        }
    }
}

