/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.lucene.extractor;

import com.atlassian.bonnie.Searchable;
import com.atlassian.bonnie.search.Extractor;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.search.lucene.ContentPermissionSearchUtils;
import com.atlassian.confluence.security.ContentPermissionSet;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Category;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;

public class ContentPermissionsExtractor
implements Extractor {
    public static final Category log = Category.getInstance(ContentPermissionsExtractor.class);
    public static final String PERMISSION_SETS_FIELD = "permissionSets";
    private ContentPermissionManager contentPermissionManager;

    public void addFields(Document document, StringBuffer stringBuffer, Searchable searchable) {
        String encodedCredentialsAsString;
        List inheritedContentPermSets;
        ContentEntityObject ceo = null;
        if (searchable instanceof Comment) {
            ceo = ((Comment)searchable).getPage();
        } else if (searchable instanceof Attachment) {
            ceo = ((Attachment)searchable).getContent();
        } else if (searchable instanceof Page) {
            ceo = (Page)searchable;
        }
        if (!(ceo instanceof Page)) {
            return;
        }
        ArrayList<String> encodedCredentials = new ArrayList<String>();
        if (ceo.hasPermissions("View")) {
            ContentPermissionSet contentPermissionSet = ceo.getContentPermissionSet("View");
            encodedCredentials.add(ContentPermissionSearchUtils.getEncodedContentPermissionSet(contentPermissionSet));
        }
        if ((inheritedContentPermSets = this.contentPermissionManager.getInheritedContentPermissionSets(ceo)).size() > 0) {
            for (ContentPermissionSet contentPermissionSet : inheritedContentPermSets) {
                encodedCredentials.add(ContentPermissionSearchUtils.getEncodedContentPermissionSet(contentPermissionSet));
            }
        }
        if (TextUtils.stringSet((String)(encodedCredentialsAsString = StringUtils.join(encodedCredentials.iterator(), (char)'&')))) {
            document.add((Fieldable)new Field(PERMISSION_SETS_FIELD, encodedCredentialsAsString, Field.Store.NO, Field.Index.UN_TOKENIZED));
        }
    }

    public void setContentPermissionManager(ContentPermissionManager contentPermissionManager) {
        this.contentPermissionManager = contentPermissionManager;
    }
}

