/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.lucene.extractor;

import com.atlassian.bonnie.Searchable;
import com.atlassian.bonnie.search.Extractor;
import com.atlassian.confluence.core.PageContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.util.GeneralUtil;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;

public class PageContentEntityObjectExtractor
implements Extractor {
    public void addFields(Document document, StringBuffer defaultSearchableText, Searchable searchable) {
        if (searchable instanceof PageContentEntityObject) {
            PageContentEntityObject pceo = (PageContentEntityObject)searchable;
            AbstractPage page = pceo.getPage();
            String spaceType = page.getSpace().getSpaceType().toString();
            document.add((Fieldable)new Field("page.space.name", page.getSpace().getName(), Field.Store.YES, Field.Index.NO));
            document.add((Fieldable)new Field("page.urlPath", GeneralUtil.getIdBasedPageUrl(page), Field.Store.YES, Field.Index.NO));
            document.add((Fieldable)new Field("page.realTitle", page.getDisplayTitle(), Field.Store.YES, Field.Index.NO));
            document.add((Fieldable)new Field("space.type", spaceType, Field.Store.YES, Field.Index.UN_TOKENIZED));
            document.add((Fieldable)new Field("container.content.type", page.getType(), Field.Store.NO, Field.Index.UN_TOKENIZED));
        }
    }

    public static class FieldNames {
        public static final String CONTAINER_CONTENT_TYPE = "container.content.type";
        public static final String SPACE_TYPE = "space.type";
        public static final String PAGE_DISPLAY_TITLE = "page.realTitle";
        public static final String PAGE_URL_PATH = "page.urlPath";
        public static final String PAGE_SPACE_NAME = "page.space.name";
        public static final String PAGE_REAL_TITLE = "page.realTitle";
    }
}

