/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.lucene.extractor;

import com.atlassian.bonnie.Searchable;
import com.atlassian.bonnie.search.Extractor;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.spaces.Space;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;

public class SpaceContentEntityObjectExtractor
implements Extractor {
    public static final String SPACE_KEY_FIELD = "space.key";
    public static final String SPACE_NAME_FIELD = "space.name";

    public void addFields(Document document, StringBuffer defaultSearchableText, Searchable searchable) {
        if (searchable instanceof SpaceContentEntityObject) {
            SpaceContentEntityObject sceo = (SpaceContentEntityObject)searchable;
            Space space = sceo.getSpace();
            String spaceType = space.getSpaceType().toString();
            document.add((Fieldable)new Field(SPACE_NAME_FIELD, space.getName(), Field.Store.YES, Field.Index.NO));
            document.add((Fieldable)new Field(SPACE_KEY_FIELD, space.getKey(), Field.Store.YES, Field.Index.NO));
            document.add((Fieldable)new Field("space.type", spaceType, Field.Store.YES, Field.Index.UN_TOKENIZED));
            if (sceo.getOriginalVersion() != null) {
                SpaceContentEntityObject originalVersion = (SpaceContentEntityObject)sceo.getOriginalVersion();
                document.add((Fieldable)new Field("originalVersion.space.name", originalVersion.getSpace().getName(), Field.Store.YES, Field.Index.NO));
            }
        }
    }
}

