/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.lucene.filter;

import java.io.IOException;
import java.util.Stack;
import java.util.StringTokenizer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardTokenizerConstants;

public class FilenameFilter
extends TokenFilter
implements StandardTokenizerConstants {
    private static final String TOKEN_TYPE_FILE = "FILE";
    private Stack subWordStack = new Stack();

    public FilenameFilter(TokenStream tokenStream) {
        super(tokenStream);
    }

    public Token next() throws IOException {
        if (this.subWordStack.size() > 0) {
            return (Token)this.subWordStack.pop();
        }
        Token token = this.input.next();
        if (token == null) {
            return null;
        }
        this.addSubWordsToStack(token);
        return token;
    }

    private void addSubWordsToStack(Token token) {
        String termText = token.termText();
        if (termText != null && termText.indexOf(".") != -1) {
            StringTokenizer tokenizer = new StringTokenizer(termText, ".-", false);
            while (tokenizer.hasMoreTokens()) {
                Token subWord = new Token(tokenizer.nextToken(), token.startOffset(), token.endOffset(), TOKEN_TYPE_FILE);
                subWord.setPositionIncrement(0);
                this.subWordStack.push(subWord);
            }
        }
    }
}

