/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.lucene.postprocessor;

import com.atlassian.bonnie.search.DocumentPostProcessor;
import com.atlassian.confluence.mail.Mail;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.spaces.SpaceDescription;
import com.atlassian.confluence.user.PersonalInformation;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;

public class ContentBoostPostProcessor
implements DocumentPostProcessor {
    public void process(Document document) {
        String className = document.get("classname");
        if (PersonalInformation.class.getName().equals(className)) {
            document.setBoost(9.0f);
        }
        if (Page.class.getName().equals(className)) {
            document.setBoost(8.0f);
        }
        if (BlogPost.class.getName().equals(className)) {
            document.setBoost(7.0f);
        }
        if (Attachment.class.getName().equals(className)) {
            document.setBoost(6.0f);
        }
        if (Comment.class.getName().equals(className)) {
            document.setBoost(5.0f);
        }
        if (Mail.class.getName().equals(className)) {
            document.setBoost(0.5f);
        }
        if (SpaceDescription.class.getName().equals(className)) {
            document.setBoost(0.4f);
        }
        this.applyFieldBoost(document, "title", 9.0f);
        this.applyFieldBoost(document, "fullName", 8.0f);
        this.applyFieldBoost(document, "labelText", 7.0f);
        this.applyFieldBoost(document, "contentBody", 5.0f);
        this.applyFieldBoost(document, "lastModifiers", 0.5f);
    }

    private void applyFieldBoost(Document document, String fieldname, float boost) {
        Field field = document.getField(fieldname);
        if (field != null) {
            field.setBoost(boost);
        }
    }
}

