/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.lucene.queue;

import bucket.search.persistence.IndexQueueEntry;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class DatabaseQueueFlushedEntryCache {
    public static final Logger log = Logger.getLogger(DatabaseQueueFlushedEntryCache.class);
    private final Set entries;
    private final long cacheWindowMillis;

    public DatabaseQueueFlushedEntryCache(long cacheWindowMillis) {
        this.cacheWindowMillis = cacheWindowMillis;
        this.entries = new TreeSet(new Comparator(){

            public int compare(Object o1, Object o2) {
                int timeComparision;
                long time2;
                if (!(o1 instanceof IndexQueueEntry) || !(o2 instanceof IndexQueueEntry)) {
                    return 0;
                }
                IndexQueueEntry entry1 = (IndexQueueEntry)o1;
                IndexQueueEntry entry2 = (IndexQueueEntry)o2;
                long time1 = entry1.getCreationDate().getTime();
                int n = time1 < (time2 = entry2.getCreationDate().getTime()) ? -1 : (timeComparision = time1 == time2 ? 0 : 1);
                if (timeComparision == 0) {
                    long id2;
                    long id1 = entry1.getId();
                    return id1 < (id2 = entry2.getId()) ? -1 : (id1 == id2 ? 0 : 1);
                }
                return timeComparision;
            }
        });
    }

    public synchronized void add(IndexQueueEntry entry) {
        this.entries.add(entry);
    }

    public synchronized boolean contains(IndexQueueEntry entry) {
        return this.entries.contains(entry);
    }

    public synchronized void removeOldEntries(Date relativeTo) {
        IndexQueueEntry entry;
        int entriesRemoved = 0;
        Iterator iterator = this.entries.iterator();
        while (iterator.hasNext() && (entry = (IndexQueueEntry)iterator.next()).getCreationDate().getTime() < relativeTo.getTime() - this.cacheWindowMillis) {
            iterator.remove();
            ++entriesRemoved;
        }
        log.debug((Object)(entriesRemoved + " entries were removed from the flushedEntryCache."));
    }

    public synchronized void addEntries(List entriesOldestFirst, Date relativeTo) {
        IndexQueueEntry entry;
        int entriesAdded = 0;
        for (int i = entriesOldestFirst.size() - 1; i >= 0 && (entry = (IndexQueueEntry)entriesOldestFirst.get(i)).getCreationDate().getTime() >= relativeTo.getTime() - this.cacheWindowMillis; --i) {
            this.add(entry);
            ++entriesAdded;
        }
        log.debug((Object)(entriesAdded + " entries were added to the flushedEntryCache."));
    }
}

