/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.lucene.queue;

import bucket.search.persistence.IndexQueueEntry;
import com.atlassian.confluence.search.lucene.IndexTask;
import com.atlassian.confluence.search.lucene.IndexTaskQueue;
import com.atlassian.confluence.search.lucene.tasks.IndexTaskFactory;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class InMemoryIndexTaskQueue
implements IndexTaskQueue {
    private LinkedList queue = new LinkedList();
    private IndexTaskFactory indexTaskFactory;

    public int getSize() {
        return this.queue.size();
    }

    public List getQueuedEntries() {
        return new LinkedList(this.queue);
    }

    public synchronized void enqueue(IndexTask task) {
        this.addToQueue(task);
    }

    public synchronized void enqueueAll(Collection tasks) {
        Iterator i = tasks.iterator();
        while (i.hasNext()) {
            this.addToQueue((IndexTask)i.next());
        }
    }

    public List flushQueue() {
        List flushedItems = this.replaceQueueInstance();
        ListIterator<IndexTask> it = flushedItems.listIterator();
        while (it.hasNext()) {
            IndexQueueEntry entry = (IndexQueueEntry)it.next();
            it.set(this.indexTaskFactory.toTask(entry));
        }
        return flushedItems;
    }

    public synchronized void reset() {
        this.replaceQueueInstance();
    }

    private synchronized List replaceQueueInstance() {
        LinkedList myqueue = this.queue;
        this.queue = new LinkedList();
        return myqueue;
    }

    private void addToQueue(IndexTask task) {
        IndexQueueEntry entry = this.indexTaskFactory.toEntry(task);
        if (entry != null) {
            this.queue.addLast(entry);
        }
    }

    public void setIndexTaskFactory(IndexTaskFactory indexTaskFactory) {
        this.indexTaskFactory = indexTaskFactory;
    }
}

