/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.lucene.tasks;

import bucket.core.persistence.hibernate.HibernateHandle;
import com.atlassian.bonnie.AnyTypeObjectDao;
import com.atlassian.bonnie.Handle;
import com.atlassian.bonnie.Searchable;
import com.atlassian.bonnie.search.DocumentBuilder;
import com.atlassian.confluence.search.lucene.ContentIndexTask;
import java.text.ParseException;
import org.springframework.orm.hibernate.HibernateObjectRetrievalFailureException;

public abstract class BaseContentIndexTask
implements ContentIndexTask {
    protected DocumentBuilder documentBuilder;
    protected AnyTypeObjectDao anyTypeObjectDao;
    protected Handle handle;
    protected String spaceKey;
    protected transient Searchable target;

    protected BaseContentIndexTask() {
    }

    public BaseContentIndexTask(Searchable target) {
        if (!target.isIndexable()) {
            throw new IllegalArgumentException("Item is not indexable.");
        }
        this.target = target;
        this.handle = this.createHandle(target);
    }

    protected BaseContentIndexTask(String handle) throws ParseException {
        this.handle = this.createHandle(handle);
    }

    protected Handle createHandle(String handle) throws ParseException {
        return new HibernateHandle(handle);
    }

    public Searchable getTarget() {
        try {
            if (this.target == null) {
                this.target = (Searchable)this.anyTypeObjectDao.findByHandle(this.handle);
            }
            return this.target;
        }
        catch (HibernateObjectRetrievalFailureException e) {
            return null;
        }
    }

    public Handle getHandle() {
        return this.handle;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof ContentIndexTask)) {
            return false;
        }
        ContentIndexTask indexTask = (ContentIndexTask)other;
        if (indexTask.getClass() != this.getClass()) {
            return false;
        }
        return indexTask.getHandle().equals(this.getHandle());
    }

    public int hashCode() {
        return this.getHandle().hashCode();
    }

    protected Handle createHandle(Searchable target) {
        return new HibernateHandle(target);
    }

    public void setDocumentBuilder(DocumentBuilder documentBuilder) {
        this.documentBuilder = documentBuilder;
    }

    public void setAnyTypeObjectDao(AnyTypeObjectDao anyTypeObjectDao) {
        this.anyTypeObjectDao = anyTypeObjectDao;
    }

    public String toString() {
        return this.getDescription() + " Handle: " + this.getHandle();
    }
}

