/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.lucene.tasks;

import bucket.search.persistence.IndexQueueEntry;
import com.atlassian.bonnie.AnyTypeObjectDao;
import com.atlassian.bonnie.Searchable;
import com.atlassian.bonnie.search.DocumentBuilder;
import com.atlassian.confluence.search.lucene.ContentIndexTask;
import com.atlassian.confluence.search.lucene.IndexTask;
import com.atlassian.confluence.search.lucene.tasks.AddDocumentIndexTask;
import com.atlassian.confluence.search.lucene.tasks.BaseContentIndexTask;
import com.atlassian.confluence.search.lucene.tasks.DeleteDocumentIndexTask;
import com.atlassian.confluence.search.lucene.tasks.OptimizeIndexTask;
import com.atlassian.confluence.search.lucene.tasks.UnIndexSpaceIndexTask;
import com.atlassian.confluence.search.lucene.tasks.UpdateDocumentIndexTask;
import com.atlassian.confluence.spaces.Space;
import java.text.ParseException;
import org.apache.log4j.Category;

public class IndexTaskFactory {
    private static final int UNINDEXSPACE = 25;
    private static final int OPTIMIZE = 26;
    public static final Category LOG = Category.getInstance(IndexTaskFactory.class);
    private AnyTypeObjectDao anyTypeObjectDao;
    private DocumentBuilder documentBuilder;

    public IndexQueueEntry toEntry(IndexTask task) {
        String handle = null;
        if (task instanceof ContentIndexTask) {
            ContentIndexTask contentIndexTask = (ContentIndexTask)task;
            handle = contentIndexTask.getHandle().toString();
        }
        if (task instanceof AddDocumentIndexTask) {
            return new IndexQueueEntry(1, handle);
        }
        if (task instanceof DeleteDocumentIndexTask) {
            return new IndexQueueEntry(2, handle);
        }
        if (task instanceof UpdateDocumentIndexTask) {
            return new IndexQueueEntry(3, handle);
        }
        if (task instanceof UnIndexSpaceIndexTask) {
            return new IndexQueueEntry(25, handle);
        }
        if (task instanceof OptimizeIndexTask) {
            return new IndexQueueEntry(26, null);
        }
        throw new IllegalArgumentException("Cannot convert index task to queue entry for unknown type: " + task);
    }

    public IndexTask toTask(IndexQueueEntry entry) {
        BaseContentIndexTask indexTask = null;
        try {
            switch (entry.getType()) {
                case 1: {
                    indexTask = new AddDocumentIndexTask(entry.getHandle());
                    break;
                }
                case 2: {
                    indexTask = new DeleteDocumentIndexTask(entry.getHandle());
                    break;
                }
                case 3: {
                    indexTask = new UpdateDocumentIndexTask(entry.getHandle());
                    break;
                }
                case 25: {
                    indexTask = new UnIndexSpaceIndexTask(entry.getHandle());
                    break;
                }
                case 26: {
                    return new OptimizeIndexTask();
                }
                default: {
                    throw new IllegalArgumentException("Unsupported index queue entry: " + entry);
                }
            }
            this.setTaskDependencies(indexTask);
        }
        catch (ParseException e) {
            LOG.error((Object)"", (Throwable)e);
        }
        return indexTask;
    }

    public void setAnyTypeObjectDao(AnyTypeObjectDao anyTypeObjectDao) {
        this.anyTypeObjectDao = anyTypeObjectDao;
    }

    public void setDocumentBuilder(DocumentBuilder documentBuilder) {
        this.documentBuilder = documentBuilder;
    }

    private void setTaskDependencies(BaseContentIndexTask task) {
        task.setAnyTypeObjectDao(this.anyTypeObjectDao);
        task.setDocumentBuilder(this.documentBuilder);
    }

    public IndexTask createUnIndexSpaceTask(Space space) {
        UnIndexSpaceIndexTask result = new UnIndexSpaceIndexTask(space);
        this.setTaskDependencies(result);
        return result;
    }

    public IndexTask createDeleteDocumentTask(Searchable searchable) {
        DeleteDocumentIndexTask result = new DeleteDocumentIndexTask(searchable);
        this.setTaskDependencies(result);
        return result;
    }

    public IndexTask createUpdateDocumentTask(Searchable searchable) {
        UpdateDocumentIndexTask result = new UpdateDocumentIndexTask(searchable);
        this.setTaskDependencies(result);
        return result;
    }

    public IndexTask createAddDocumentTask(Searchable searchable) {
        AddDocumentIndexTask result = new AddDocumentIndexTask(searchable);
        this.setTaskDependencies(result);
        return result;
    }

    public AddDocumentIndexTask createAddDocumentTask(String handle) throws ParseException {
        AddDocumentIndexTask result = new AddDocumentIndexTask(handle);
        this.setTaskDependencies(result);
        return result;
    }

    public DeleteDocumentIndexTask createDeleteDocumentTask(String handle) throws ParseException {
        DeleteDocumentIndexTask result = new DeleteDocumentIndexTask(handle);
        this.setTaskDependencies(result);
        return result;
    }
}

