/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.scope;

import com.atlassian.confluence.search.ConfluenceSearchScope;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.user.User;
import java.util.HashSet;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class PermittedSpacesScope
implements ConfluenceSearchScope {
    private SpaceManager spaceManager;

    public PermittedSpacesScope(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public void restrictQuery(User user, BooleanQuery query) {
        if (GeneralUtil.isSuperUser(user)) {
            return;
        }
        List allSpaces = this.spaceManager.getAllSpaces();
        List visibleSpaces = this.spaceManager.getPermittedSpaces(user);
        this.restrictQueryByInvisibleSpaces(query, allSpaces, visibleSpaces);
    }

    private void restrictQueryByInvisibleSpaces(BooleanQuery query, List allSpaces, List visibleSpaces) {
        BooleanQuery.setMaxClauseCount((int)Math.max(allSpaces.size() - visibleSpaces.size() + 100, 1024));
        BooleanQuery subQuery = new BooleanQuery();
        HashSet visibleSpacesSet = new HashSet(visibleSpaces);
        for (Space space : allSpaces) {
            if (visibleSpacesSet.contains(space)) continue;
            subQuery.add((Query)new TermQuery(new Term("spacekey", space.getKey())), BooleanClause.Occur.SHOULD);
        }
        query.add((Query)subQuery, BooleanClause.Occur.MUST_NOT);
    }
}

