/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.scope;

import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.search.ConfluenceSearchScope;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceType;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.user.User;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class SpaceScope
implements ConfluenceSearchScope {
    private List spaceKeys;
    public static final String SCOPE_PREFIX = "conf_";
    public static final String ALL = "conf_all";
    public static final String FAVOURITES = "conf_favorites";
    public static final String GLOBAL = "conf_global";
    public static final String PERSONAL = "conf_personal";
    public static final List AVAILABLE_SCOPES = Collections.unmodifiableList(Arrays.asList("conf_all", "conf_favorites", "conf_global", "conf_personal"));
    private LabelManager labelManager;

    public static SpaceScope fromSpaceList(List spaces, List spaceScopes, LabelManager labelManager) {
        ArrayList<String> spaceKeys = new ArrayList<String>(spaces.size() + spaceScopes.size());
        for (Space space : spaces) {
            spaceKeys.add(space.getKey());
        }
        spaceKeys.addAll(spaceScopes);
        return new SpaceScope(spaceKeys, labelManager);
    }

    public SpaceScope(String spaceKey, LabelManager labelManager) {
        this.labelManager = labelManager;
        this.spaceKeys = new ArrayList(1);
        if (TextUtils.stringSet((String)spaceKey)) {
            this.spaceKeys.add(spaceKey);
        }
    }

    public SpaceScope(List spaceKeys, LabelManager labelManager) {
        this.labelManager = labelManager;
        this.spaceKeys = spaceKeys;
    }

    public void restrictQuery(User user, BooleanQuery query) {
        BooleanQuery subQuery = new BooleanQuery();
        if (this.spaceKeys == null || this.spaceKeys.isEmpty() || query == null) {
            return;
        }
        if (this.spaceKeys.contains(ALL)) {
            return;
        }
        if (this.spaceKeys.contains(GLOBAL)) {
            this.searchAllGlobalSpaces(subQuery);
            this.spaceKeys.remove(GLOBAL);
        }
        if (this.spaceKeys.contains(PERSONAL)) {
            this.searchPersonalSpaces(subQuery);
            this.spaceKeys.remove(PERSONAL);
        }
        if (this.spaceKeys.contains(FAVOURITES)) {
            this.searchFavouriteSpaces(subQuery);
            this.spaceKeys.remove(FAVOURITES);
        }
        for (String key : this.spaceKeys) {
            if (key == null) continue;
            subQuery.add((Query)new TermQuery(new Term("spacekey", key)), BooleanClause.Occur.SHOULD);
        }
        query.add((Query)subQuery, BooleanClause.Occur.MUST);
    }

    private void searchPersonalSpaces(BooleanQuery subQuery) {
        subQuery.add((Query)new TermQuery(new Term("space.type", SpaceType.PERSONAL.toString())), BooleanClause.Occur.SHOULD);
    }

    private void searchAllGlobalSpaces(BooleanQuery subQuery) {
        subQuery.add((Query)new TermQuery(new Term("space.type", SpaceType.GLOBAL.toString())), BooleanClause.Occur.SHOULD);
    }

    private void searchFavouriteSpaces(BooleanQuery subQuery) {
        User user = AuthenticatedUserThreadLocal.getUser();
        if (user == null) {
            return;
        }
        List spaceList = this.labelManager.getFavouriteSpaces(user.getName());
        for (Space space : spaceList) {
            subQuery.add((Query)new TermQuery(new Term("spacekey", space.getKey())), BooleanClause.Occur.SHOULD);
        }
    }

    public LabelManager getLabelManager() {
        return this.labelManager;
    }

    public void setLabelManager(LabelManager labelManager) {
        this.labelManager = labelManager;
    }
}

