/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.service;

import com.atlassian.confluence.mail.Mail;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.spaces.SpaceDescription;
import com.atlassian.confluence.user.PersonalInformation;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ContentTypeEnum {
    PAGE("page", Page.class.getName()),
    COMMENT("comment", Comment.class.getName()),
    BLOG("blogpost", BlogPost.class.getName()),
    ATTACHMENT("attachment", Attachment.class.getName()),
    PERSONAL_INFORMATION("userinfo", PersonalInformation.class.getName()),
    SPACE_DESCRIPTION("spacedesc", SpaceDescription.class.getName()),
    PERSONAL_SPACE_DESCRIPTION("personalspacedesc", SpaceDescription.class.getName()),
    MAIL("mail", Mail.class.getName());

    private static final Map<String, ContentTypeEnum> lookup;
    private final String representation;
    private final String clsStr;

    private ContentTypeEnum(String str, String c) {
        this.representation = str;
        this.clsStr = c;
    }

    public String getRepresentation() {
        return this.representation;
    }

    public String getTypeClass() {
        return this.clsStr;
    }

    public String toString() {
        return this.getRepresentation();
    }

    public static ContentTypeEnum get(String rep) {
        return lookup.get(rep);
    }

    static {
        lookup = new HashMap<String, ContentTypeEnum>(8);
        for (ContentTypeEnum cont : EnumSet.allOf(ContentTypeEnum.class)) {
            lookup.put(cont.getRepresentation(), cont);
        }
    }
}

