/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.service;

import com.atlassian.confluence.search.service.PredefinedQueryBuilder;
import com.atlassian.confluence.search.service.SearchQueryParameters;
import com.atlassian.confluence.search.v2.BooleanOperator;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.query.AllQuery;
import com.atlassian.confluence.search.v2.query.BooleanQuery;
import com.atlassian.confluence.search.v2.query.ContentTypeQuery;
import com.atlassian.confluence.search.v2.query.CreatorQuery;
import com.atlassian.confluence.search.v2.query.DateRangeQuery;
import com.atlassian.confluence.search.v2.query.InSpaceQuery;
import com.atlassian.confluence.search.v2.query.LastModifierQuery;
import com.atlassian.confluence.search.v2.query.PermittedSpacesQuery;
import com.atlassian.confluence.search.v2.query.SpaceCategoryQuery;
import com.atlassian.confluence.search.v2.query.TextFieldQuery;
import com.atlassian.confluence.setup.settings.SettingsManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPredefinedQueryBuilder
implements PredefinedQueryBuilder {
    private final SettingsManager settingsManager;

    public DefaultPredefinedQueryBuilder(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    @Override
    public SearchQuery siteSearchQuery(SearchQueryParameters searchQueryParams) {
        HashSet<SearchQuery> scopedQuery = new HashSet<SearchQuery>();
        if (StringUtils.isBlank((String)searchQueryParams.getQuery())) {
            scopedQuery.add(new AllQuery());
        } else {
            scopedQuery.add(this.getAggregatedContentQuery(searchQueryParams.getQuery()));
        }
        if (searchQueryParams.getContentType() != null) {
            scopedQuery.add(new ContentTypeQuery(searchQueryParams.getContentType()));
        }
        if (searchQueryParams.getLastModified() != null) {
            scopedQuery.add(new DateRangeQuery(searchQueryParams.getLastModified(), DateRangeQuery.DateRangeQueryType.MODIFIED));
        }
        if (searchQueryParams.getCategory() != null) {
            scopedQuery.add(new SpaceCategoryQuery(searchQueryParams.getCategory()));
        }
        if (searchQueryParams.getSpaceKeys() != null && !searchQueryParams.getSpaceKeys().isEmpty()) {
            scopedQuery.add(new InSpaceQuery(searchQueryParams.getSpaceKeys()));
        }
        if (StringUtils.isNotBlank((String)searchQueryParams.getContributor())) {
            scopedQuery.add(this.contributorQuery(searchQueryParams.getContributor()));
        }
        scopedQuery.add(PermittedSpacesQuery.getInstance());
        return new BooleanQuery(scopedQuery, null, null);
    }

    private SearchQuery getAggregatedContentQuery(String query) {
        HashSet<TextFieldQuery> contentQueries = new HashSet<TextFieldQuery>();
        contentQueries.addAll(this.contentQuery(query));
        if (!this.settingsManager.getGlobalSettings().isSharedMode()) {
            contentQueries.addAll(this.userQuery(query));
        }
        contentQueries.addAll(this.mailQuery(query));
        return BooleanQuery.composeOrQuery(contentQueries);
    }

    private List<TextFieldQuery> contentQuery(String query) {
        ArrayList<TextFieldQuery> subQueries = new ArrayList<TextFieldQuery>();
        subQueries.add(new TextFieldQuery("title", query, BooleanOperator.AND));
        subQueries.add(new TextFieldQuery("labelText", query, BooleanOperator.AND));
        subQueries.add(new TextFieldQuery("contentBody", query, BooleanOperator.AND));
        subQueries.add(new TextFieldQuery("filename", query, BooleanOperator.AND));
        return subQueries;
    }

    private List<TextFieldQuery> userQuery(String query) {
        ArrayList<TextFieldQuery> subQueries = new ArrayList<TextFieldQuery>();
        subQueries.add(new TextFieldQuery("username", query, BooleanOperator.AND));
        subQueries.add(new TextFieldQuery("fullName", query, BooleanOperator.AND));
        subQueries.add(new TextFieldQuery("email", query, BooleanOperator.AND));
        return subQueries;
    }

    private SearchQuery contributorQuery(String contributor) {
        HashSet<SearchQuery> subQueries = new HashSet<SearchQuery>();
        subQueries.add(new CreatorQuery(contributor));
        subQueries.add(new LastModifierQuery(contributor));
        return BooleanQuery.composeOrQuery(subQueries);
    }

    private List<TextFieldQuery> mailQuery(String query) {
        ArrayList<TextFieldQuery> subQueries = new ArrayList<TextFieldQuery>();
        subQueries.add(new TextFieldQuery("from", query, BooleanOperator.AND));
        subQueries.add(new TextFieldQuery("recipients", query, BooleanOperator.AND));
        return subQueries;
    }
}

