/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.v2.lucene;

import com.atlassian.confluence.plugin.CompositeModuleDescriptorPredicate;
import com.atlassian.confluence.plugin.descriptor.search.AbstractLuceneMapperModuleDescriptor;
import com.atlassian.confluence.plugin.descriptor.search.LuceneQueryMapperModuleDescriptor;
import com.atlassian.confluence.plugin.descriptor.search.LuceneResultFilterMapperModuleDescriptor;
import com.atlassian.confluence.plugin.descriptor.search.LuceneSearchFilterMapperModuleDescriptor;
import com.atlassian.confluence.plugin.descriptor.search.LuceneSortMapperModuleDescriptor;
import com.atlassian.confluence.search.v2.lucene.LuceneMapperClassPredicate;
import com.atlassian.confluence.search.v2.lucene.LuceneQueryMapper;
import com.atlassian.confluence.search.v2.lucene.LuceneResultFilterMapper;
import com.atlassian.confluence.search.v2.lucene.LuceneSearchFilterMapper;
import com.atlassian.confluence.search.v2.lucene.LuceneSearchMapperRegistry;
import com.atlassian.confluence.search.v2.lucene.LuceneSortMapper;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.predicate.EnabledModulePredicate;
import com.atlassian.plugin.predicate.ModuleDescriptorPredicate;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheBackedLuceneSearchMapperRegistry
implements LuceneSearchMapperRegistry {
    private final Logger log = Logger.getLogger(CacheBackedLuceneSearchMapperRegistry.class);
    protected final PluginAccessor pluginAccessor;
    private volatile Map<CacheKey, AbstractLuceneMapperModuleDescriptor> luceneMapperModuleDescriptorsCache;
    private static final Object cacheUpdateLock = new Object();
    private ModuleDescriptorPredicate enabledLuceneMapperModulePredicate;

    @Override
    public LuceneQueryMapper getQueryMapper(String key) {
        return (LuceneQueryMapper)this.getMapper(key, LuceneQueryMapperModuleDescriptor.class);
    }

    @Override
    public LuceneSortMapper getSortMapper(String key) {
        return (LuceneSortMapper)this.getMapper(key, LuceneSortMapperModuleDescriptor.class);
    }

    @Override
    public LuceneResultFilterMapper getResultFilterMapper(String key) {
        return (LuceneResultFilterMapper)this.getMapper(key, LuceneResultFilterMapperModuleDescriptor.class);
    }

    @Override
    public LuceneSearchFilterMapper getSearchFilterMapper(String key) {
        return (LuceneSearchFilterMapper)this.getMapper(key, LuceneSearchFilterMapperModuleDescriptor.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synchronizeModuleDescriptorsCache() {
        Object object = cacheUpdateLock;
        synchronized (object) {
            HashMap<CacheKey, AbstractLuceneMapperModuleDescriptor> tempCache = new HashMap<CacheKey, AbstractLuceneMapperModuleDescriptor>();
            Collection moduleDescriptors = this.pluginAccessor.getModuleDescriptors(this.enabledLuceneMapperModulePredicate);
            for (AbstractLuceneMapperModuleDescriptor moduleDescriptor : moduleDescriptors) {
                for (String handleKey : moduleDescriptor.getHandledKeys()) {
                    CacheKey key = new CacheKey(((Object)((Object)moduleDescriptor)).getClass(), handleKey);
                    if (tempCache.containsKey(key)) {
                        this.log.warn((Object)("A lucene mapper (" + ((AbstractLuceneMapperModuleDescriptor)((Object)tempCache.get(key))).getModuleClass().getName() + ") has already been assigned to handle the key: " + key + " - " + moduleDescriptor.getModuleClass() + " has been ignored."));
                        continue;
                    }
                    tempCache.put(key, moduleDescriptor);
                }
            }
            this.luceneMapperModuleDescriptorsCache = tempCache;
        }
    }

    private Object getMapper(String handleKey, Class<? extends AbstractLuceneMapperModuleDescriptor> mapperModuleDescriptorClass) {
        CacheKey key = new CacheKey(mapperModuleDescriptorClass, handleKey);
        AbstractLuceneMapperModuleDescriptor moduleDescriptor = this.getLuceneMapperModuleDescriptorsCache().get(key);
        if (moduleDescriptor == null) {
            return null;
        }
        return moduleDescriptor.getModule();
    }

    private Map<CacheKey, AbstractLuceneMapperModuleDescriptor> getLuceneMapperModuleDescriptorsCache() {
        if (this.luceneMapperModuleDescriptorsCache == null) {
            this.synchronizeModuleDescriptorsCache();
        }
        return this.luceneMapperModuleDescriptorsCache;
    }

    public CacheBackedLuceneSearchMapperRegistry(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
        this.enabledLuceneMapperModulePredicate = new CompositeModuleDescriptorPredicate((ModuleDescriptorPredicate)new EnabledModulePredicate(pluginAccessor), new LuceneMapperClassPredicate(AbstractLuceneMapperModuleDescriptor.class));
    }

    private static final class CacheKey {
        private final Class moduleDescriptorclass;
        private final String handleKey;

        public CacheKey(Class moduleDescriptorclass, String handleKey) {
            this.moduleDescriptorclass = moduleDescriptorclass;
            this.handleKey = handleKey;
        }

        public boolean equals(Object o) {
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            return new EqualsBuilder().append((Object)this.moduleDescriptorclass, (Object)other.moduleDescriptorclass).append((Object)this.handleKey, (Object)other.handleKey).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.moduleDescriptorclass).append((Object)this.handleKey).toHashCode();
        }
    }
}

