/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.v2.lucene;

import com.atlassian.bonnie.AnyTypeObjectDao;
import com.atlassian.bonnie.Searchable;
import com.atlassian.bonnie.analyzer.LuceneAnalyzerFactory;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.search.v2.Search;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchResult;
import com.atlassian.confluence.search.v2.SearchResults;
import com.atlassian.confluence.search.v2.lucene.LuceneMapperNotFoundException;
import com.atlassian.confluence.search.v2.lucene.LuceneResultFilter;
import com.atlassian.confluence.search.v2.lucene.LuceneSearchMapper;
import com.atlassian.confluence.search.v2.lucene.LuceneSearchResults;
import com.atlassian.confluence.search.v2.lucene.LuceneSearcher;
import com.atlassian.confluence.search.v2.query.TextFieldQuery;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneSearchManager
implements SearchManager {
    public static final Logger log = Logger.getLogger(LuceneSearchManager.class);
    private final LuceneSearchMapper mapper;
    private final LuceneSearcher searcher;
    private final AnyTypeObjectDao anyTypeObjectDao;
    private final LuceneAnalyzerFactory luceneAnalyzerFactory;

    public LuceneSearchManager(LuceneSearchMapper luceneSearchMapper, LuceneSearcher luceneSearcher, AnyTypeObjectDao anyTypeObjectDao, LuceneAnalyzerFactory luceneAnalyzerFactory) {
        this.mapper = luceneSearchMapper;
        this.searcher = luceneSearcher;
        this.anyTypeObjectDao = anyTypeObjectDao;
        this.luceneAnalyzerFactory = luceneAnalyzerFactory;
    }

    @Override
    public SearchResults search(Search search) throws InvalidSearchException {
        try {
            Filter searchFilter;
            Query query = this.mapper.convertToLuceneQuery(search.getQuery());
            Sort sort = search.getSort() == null ? null : this.mapper.convertToLuceneSort(search.getSort());
            LuceneResultFilter resultFilter = search.getResultFilter() == null ? null : this.mapper.convertToLuceneResultFilter(search.getResultFilter());
            Filter filter = searchFilter = search.getSearchFilter() == null ? null : this.mapper.convertToLuceneSearchFilter(search.getSearchFilter());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Mapped Lucene Search: " + query));
            }
            LuceneSearchResults results = this.searcher.search(query, sort, searchFilter, resultFilter);
            String rawQuery = LuceneSearchManager.getRawQuery(search.getQuery());
            if (rawQuery != null) {
                results.setSearchWords(this.getSearchWords(rawQuery));
            }
            return results;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid search query found in specified search.", e);
        }
        catch (LuceneMapperNotFoundException e) {
            throw new InvalidSearchException("A lucene mapper could not be found to map the specified search.", e);
        }
    }

    private List<String> getSearchWords(String rawQuery) {
        ArrayList<String> searchWords = new ArrayList<String>();
        Analyzer analyzer = this.luceneAnalyzerFactory.createAnalyzer();
        TokenStream tokens = analyzer.tokenStream(null, (Reader)new StringReader(rawQuery));
        try {
            Token token;
            while ((token = tokens.next()) != null) {
                searchWords.add(token.termText());
            }
        }
        catch (IOException e) {
            log.error((Object)"Error iterating through token stream.", (Throwable)e);
        }
        return searchWords;
    }

    @Override
    public List<Searchable> searchEntities(Search search) throws InvalidSearchException {
        return this.convertToEntities(this.search(search), true);
    }

    @Override
    public List<Searchable> convertToEntities(SearchResults searchResults, boolean stripNull) {
        ArrayList<Searchable> convertedEntities = new ArrayList<Searchable>(searchResults.size());
        Iterator<SearchResult> it = searchResults.iterator();
        while (it.hasNext()) {
            SearchResult result = it.next();
            convertedEntities.add((Searchable)this.anyTypeObjectDao.findByHandle(result.getHandle()));
        }
        if (stripNull) {
            return this.stripNulls(convertedEntities);
        }
        return convertedEntities;
    }

    private List<Searchable> stripNulls(List<Searchable> list) {
        ArrayList<Searchable> newList = new ArrayList<Searchable>(list);
        Iterator it = newList.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (o != null) continue;
            it.remove();
        }
        return newList;
    }

    static String getRawQuery(SearchQuery query) {
        if (query instanceof TextFieldQuery) {
            return ((TextFieldQuery)query).getRawQuery();
        }
        if (query.getParameters() != null) {
            for (Object obj : query.getParameters()) {
                String rawQuery;
                if (!(obj instanceof SearchQuery) || (rawQuery = LuceneSearchManager.getRawQuery((SearchQuery)obj)) == null) continue;
                return rawQuery;
            }
        }
        return null;
    }
}

