/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.v2.lucene;

import bucket.core.persistence.hibernate.HibernateHandle;
import com.atlassian.bonnie.Handle;
import com.atlassian.bonnie.LuceneUtils;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelParser;
import com.atlassian.confluence.labels.LabelPermissionSupport;
import com.atlassian.confluence.labels.ParsedLabelName;
import com.atlassian.confluence.search.v2.SearchResult;
import com.atlassian.user.User;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.search.Hit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneSearchResult
implements SearchResult {
    static Map<String, String> INDEX_FIELD_MAPPINGS = new HashMap<String, String>();
    private final Map<String, String> results;
    private final Set<String> personalLabels;
    private final Map<String, String> extraFields;

    public LuceneSearchResult(Hit hit) throws IOException {
        Document document = hit.getDocument();
        this.results = this.convertToMap(document);
        this.personalLabels = this.getPersonalLabels(document);
        this.extraFields = this.getAdditionalResultFields(document);
    }

    public LuceneSearchResult(Map<String, String> results) {
        this.results = new HashMap<String, String>(results);
        this.extraFields = Collections.emptyMap();
        this.personalLabels = Collections.emptySet();
    }

    private Map<String, String> getAdditionalResultFields(Document document) {
        HashMap<String, String> extraResults = new HashMap<String, String>(INDEX_FIELD_MAPPINGS.size());
        for (String field : INDEX_FIELD_MAPPINGS.keySet()) {
            String luceneFieldName = INDEX_FIELD_MAPPINGS.get(field);
            String luceneFieldValue = document.get(luceneFieldName);
            if (luceneFieldValue == null) continue;
            extraResults.put(field, luceneFieldValue);
        }
        return extraResults;
    }

    @Override
    public Map<String, String> getExtraFields() {
        return this.extraFields;
    }

    @Override
    public Handle getHandle() {
        try {
            return new HibernateHandle(this.getStringResult("handle"));
        }
        catch (ParseException p) {
            throw new IllegalStateException("Unable to create hibernate handle from search index handle: " + this.getStringResult("handle"));
        }
    }

    @Override
    public String getContent() {
        return this.getStringResult("contentBody");
    }

    @Override
    public String getType() {
        return this.getStringResult("type");
    }

    @Override
    public boolean isHomePage() {
        return Boolean.valueOf(this.getStringResult("homePage"));
    }

    @Override
    public Date getCreationDate() {
        return this.getDateResult("created");
    }

    @Override
    public String getCreator() {
        return this.getStringResult("creatorName");
    }

    @Override
    public Date getLastModificationDate() {
        return this.getDateResult("modified");
    }

    @Override
    public String getLastModifier() {
        return this.getStringResult("lastModifierName");
    }

    @Override
    public String getDisplayTitle() {
        return this.getStringResult("title");
    }

    @Override
    public String getUrlPath() {
        return this.getStringResult("urlPath");
    }

    @Override
    public String getLastUpdateDescription() {
        return this.getStringResult("versionComment");
    }

    @Override
    public String getSpaceName() {
        return this.getStringResult("space.name", "page.space.name", "content.space.name");
    }

    @Override
    public String getSpaceKey() {
        return this.getStringResult("spacekey", "space.key");
    }

    @Override
    public boolean hasLabels() {
        return this.results.containsKey("labelText") && this.results.containsKey("label");
    }

    @Override
    public Set<String> getLabels(User user) {
        HashSet<String> result = new HashSet<String>();
        String labelText = this.getStringResult("labelText");
        StringTokenizer tokenizer = new StringTokenizer(labelText, " ");
        while (tokenizer.hasMoreTokens()) {
            result.add(tokenizer.nextToken());
        }
        if (user != null) {
            List<Label> labels = new ArrayList(this.personalLabels.size());
            for (String personalLabel : this.personalLabels) {
                ParsedLabelName parsedLabel = LabelParser.parse(personalLabel);
                labels.add(parsedLabel.toLabel());
            }
            labels = LabelPermissionSupport.filterVisibleLabels(labels, user, true);
            for (Label filteredLabel : labels) {
                result.add(filteredLabel.toString());
            }
        }
        return result;
    }

    private String getStringResult(String ... fieldNames) {
        for (String fieldName : fieldNames) {
            String fieldValue = this.results.get(fieldName);
            if (fieldValue == null) continue;
            return fieldValue;
        }
        return null;
    }

    private Date getDateResult(String key) {
        String value = this.getStringResult(key);
        if (value == null) {
            return null;
        }
        return LuceneUtils.stringToDate((String)value);
    }

    private Map<String, String> convertToMap(Document document) {
        List fields = document.getFields();
        HashMap<String, String> result = new HashMap<String, String>(fields.size());
        for (Field field : fields) {
            result.put(field.name(), field.stringValue());
        }
        return result;
    }

    private Set<String> getPersonalLabels(Document document) {
        Field[] fields = document.getFields("label");
        if (fields != null) {
            HashSet<String> result = new HashSet<String>(fields.length);
            for (Field field : fields) {
                String fieldValue = field.stringValue();
                if (fieldValue == null || !fieldValue.startsWith("~")) continue;
                result.add(fieldValue);
            }
            return result;
        }
        return Collections.emptySet();
    }

    static {
        INDEX_FIELD_MAPPINGS.put("attachmentDownloadPath", "downloadPath");
        INDEX_FIELD_MAPPINGS.put("attachmentTypeDescription", "niceType");
        INDEX_FIELD_MAPPINGS.put("attachmentReadableFileSize", "niceFileSize");
        INDEX_FIELD_MAPPINGS.put("containingContentDisplayTitle", "content.realTitle");
        INDEX_FIELD_MAPPINGS.put("containingPageDisplayTitle", "page.realTitle");
        INDEX_FIELD_MAPPINGS.put("containingContentUrlPath", "content.urlPath");
        INDEX_FIELD_MAPPINGS.put("containingPageUrlPath", "page.urlPath");
        INDEX_FIELD_MAPPINGS.put("username", "username");
        INDEX_FIELD_MAPPINGS.put("fullName", "fullName");
    }
}

