/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.v2.lucene;

import com.atlassian.confluence.search.v2.SearchResult;
import com.atlassian.confluence.search.v2.SearchResults;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneSearchResults
implements SearchResults {
    private final List luceneResult;
    private final int unfilteredResultsCount;
    private List<String> searchWords;
    public static LuceneSearchResults EMPTY_RESULTS = new LuceneSearchResults(Collections.emptyList(), 0);

    public LuceneSearchResults(List luceneResult, int unfilteredResultsCount) {
        this.luceneResult = luceneResult;
        this.unfilteredResultsCount = unfilteredResultsCount;
    }

    List getRawResults() {
        return this.luceneResult;
    }

    @Override
    public int getUnfilteredResultsCount() {
        return this.unfilteredResultsCount;
    }

    @Override
    public int size() {
        return this.luceneResult.size();
    }

    public Iterator iterator() {
        return new ResultsIterator();
    }

    @Override
    public List<SearchResult> getAll() {
        return new ArrayList<SearchResult>(this.luceneResult);
    }

    @Override
    public List<String> getSearchWords() {
        return this.searchWords;
    }

    public void setSearchWords(List<String> searchWords) {
        this.searchWords = searchWords;
    }

    private class ResultsIterator
    implements Iterator {
        int offset = 0;

        private ResultsIterator() {
        }

        public boolean hasNext() {
            return this.offset < LuceneSearchResults.this.luceneResult.size();
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return LuceneSearchResults.this.luceneResult.get(this.offset++);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

