/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.v2.lucene;

import com.atlassian.bonnie.ILuceneConnection;
import com.atlassian.confluence.search.v2.lucene.LuceneResultFilter;
import com.atlassian.confluence.search.v2.lucene.LuceneSearchResult;
import com.atlassian.confluence.search.v2.lucene.NullResultFilter;
import com.atlassian.confluence.search.v2.lucene.WrappedHitImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Hit;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;

public class SearcherAction
implements ILuceneConnection.SearcherAction {
    private static Logger log = Logger.getLogger(SearcherAction.class);
    private final Query query;
    private final Filter luceneFilter;
    private final Sort sort;
    private final LuceneResultFilter resultsFilter;
    private List results;
    private int unfilteredResultsCount;
    private static final int ARBITRARY_RESULTS_LIST_SIZE = 100;

    public SearcherAction(Query query, Filter luceneFilter) {
        this(query, luceneFilter, null);
    }

    public SearcherAction(Query query, Filter luceneFilter, Sort sort) {
        this(query, luceneFilter, sort, null);
    }

    public SearcherAction(Query query, Filter luceneFilter, Sort sort, LuceneResultFilter resultsFilter) {
        this.query = query;
        this.luceneFilter = luceneFilter;
        this.sort = sort;
        this.resultsFilter = resultsFilter == null ? new NullResultFilter() : resultsFilter;
    }

    public boolean perform(IndexSearcher searcher) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Query: " + this.query));
        }
        Hits hits = this.sort == null ? searcher.search(this.query, this.luceneFilter) : searcher.search(this.query, this.luceneFilter, this.sort);
        this.unfilteredResultsCount = hits.length();
        List results = this.makeEmptyListOfExpectedSize(hits);
        Iterator it = hits.iterator();
        while (it.hasNext() && this.resultsFilter.shouldContinueIterating()) {
            Hit hit = (Hit)it.next();
            if (!this.resultsFilter.isIncludedInResults(new WrappedHitImpl(hit))) continue;
            results.add(new LuceneSearchResult(hit));
        }
        this.results = results;
        return true;
    }

    private List makeEmptyListOfExpectedSize(Hits hits) {
        if (this.resultsFilter.getExpectedResultsCount() > 0) {
            return new ArrayList(Math.min(hits.length(), this.resultsFilter.getExpectedResultsCount()));
        }
        return new ArrayList(100);
    }

    public List getResults() {
        return this.results;
    }

    public int getUnfilteredResultsCount() {
        return this.unfilteredResultsCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearcherAction that = (SearcherAction)o;
        if (this.luceneFilter != null ? !this.luceneFilter.equals(that.luceneFilter) : that.luceneFilter != null) {
            return false;
        }
        if (this.query != null ? !this.query.equals(that.query) : that.query != null) {
            return false;
        }
        if (this.resultsFilter != null ? !this.resultsFilter.equals(that.resultsFilter) : that.resultsFilter != null) {
            return false;
        }
        return !(this.sort != null ? !this.sort.equals(that.sort) : that.sort != null);
    }

    public int hashCode() {
        int result = this.query != null ? this.query.hashCode() : 0;
        result = 31 * result + (this.luceneFilter != null ? this.luceneFilter.hashCode() : 0);
        result = 31 * result + (this.sort != null ? this.sort.hashCode() : 0);
        result = 31 * result + (this.resultsFilter != null ? this.resultsFilter.hashCode() : 0);
        result = 31 * result + (this.results != null ? ((Object)this.results).hashCode() : 0);
        return result;
    }
}

