/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.v2.lucene;

import com.atlassian.confluence.search.v2.lucene.LuceneQueryMapper;
import com.atlassian.confluence.search.v2.lucene.LuceneResultFilterMapper;
import com.atlassian.confluence.search.v2.lucene.LuceneSearchFilterMapper;
import com.atlassian.confluence.search.v2.lucene.LuceneSearchMapperRegistry;
import com.atlassian.confluence.search.v2.lucene.LuceneSortMapper;
import com.atlassian.confluence.search.v2.lucene.SearchMappersThreadLocal;
import java.util.Map;

public class ThreadCachedSearchMapperRegistry
implements LuceneSearchMapperRegistry {
    private final LuceneSearchMapperRegistry registry;

    public ThreadCachedSearchMapperRegistry(LuceneSearchMapperRegistry delegateRegistry) {
        this.registry = delegateRegistry;
    }

    public LuceneQueryMapper getQueryMapper(String key) {
        Map<String, LuceneQueryMapper> mappers = SearchMappersThreadLocal.getQueryMappers();
        if (mappers != null) {
            return mappers.get(key);
        }
        return this.registry.getQueryMapper(key);
    }

    public LuceneResultFilterMapper getResultFilterMapper(String key) {
        Map<String, LuceneResultFilterMapper> mappers = SearchMappersThreadLocal.getResultFilterMappers();
        if (mappers != null) {
            return mappers.get(key);
        }
        return this.registry.getResultFilterMapper(key);
    }

    public LuceneSortMapper getSortMapper(String key) {
        Map<String, LuceneSortMapper> mappers = SearchMappersThreadLocal.getSortMappers();
        if (mappers != null) {
            return mappers.get(key);
        }
        return this.registry.getSortMapper(key);
    }

    public LuceneSearchFilterMapper getSearchFilterMapper(String key) {
        Map<String, LuceneSearchFilterMapper> mappers = SearchMappersThreadLocal.getSearchFilterMappers();
        if (mappers != null) {
            return mappers.get(key);
        }
        return this.registry.getSearchFilterMapper(key);
    }
}

