/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.v2.lucene.compatibility;

import com.atlassian.confluence.core.ListQuery;
import com.atlassian.confluence.core.SmartListManager;
import com.atlassian.confluence.search.lucene.ConfluenceIndexManager;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.search.v2.Search;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchResults;
import com.atlassian.confluence.search.v2.lucene.LuceneSearchResults;
import com.atlassian.confluence.search.v2.lucene.compatibility.ListQueryToSearchConverter;
import com.atlassian.confluence.search.v2.lucene.compatibility.SearchResultToSearchResultWithExcerptConverter;
import java.util.List;
import org.apache.log4j.Logger;

public class V2SearchSmartListManager
implements SmartListManager {
    private static Logger log = Logger.getLogger(V2SearchSmartListManager.class);
    private final SearchManager searchManager;
    private final ConfluenceIndexManager indexManager;

    public V2SearchSmartListManager(SearchManager searchManager, ConfluenceIndexManager indexManager) {
        this.searchManager = searchManager;
        this.indexManager = indexManager;
    }

    public List getListQueryResults(ListQuery listQuery, boolean loadObjects) {
        SearchResults results;
        Search search = ListQueryToSearchConverter.convertToSearch(listQuery);
        try {
            results = this.searchManager.search(search);
        }
        catch (InvalidSearchException e) {
            log.warn((Object)"Could not perform search produced by ListQueryToSearchConverter.");
            results = LuceneSearchResults.EMPTY_RESULTS;
        }
        if (loadObjects) {
            return this.searchManager.convertToEntities(results, true);
        }
        return SearchResultToSearchResultWithExcerptConverter.convertToSearchResultWithExcerpt(results);
    }

    public String getStatusMessageKey() {
        if (this.indexManager.isReIndexing()) {
            return "reindex.in.progress";
        }
        return null;
    }
}

