/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.v2.lucene.mapper;

import com.atlassian.confluence.search.lucene.filter.ChainedFilter;
import com.atlassian.confluence.search.lucene.filter.OrderedNGramMatchingFilter;
import com.atlassian.confluence.search.v2.lucene.LuceneSearchFilterMapper;
import com.atlassian.confluence.search.v2.searchfilter.AuthorSearchFilter;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorSearchFilterMapper
implements LuceneSearchFilterMapper<AuthorSearchFilter> {
    private Analyzer queryAnalyzer;

    @Override
    public Filter convertToLuceneSearchFilter(AuthorSearchFilter authorSearchFilter) {
        OrderedNGramMatchingFilter startGramFilter = new OrderedNGramMatchingFilter("personal-info-start-ngrams", authorSearchFilter.getQuery(), this.queryAnalyzer);
        OrderedNGramMatchingFilter ngramFilter = new OrderedNGramMatchingFilter("personal-info-ngrams", authorSearchFilter.getQuery(), this.queryAnalyzer);
        Filter[] filters = new Filter[]{startGramFilter, ngramFilter};
        return new ChainedFilter(filters, 1);
    }

    public void setQueryAnalyzer(Analyzer queryAnalyzer) {
        this.queryAnalyzer = queryAnalyzer;
    }
}

