/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.v2.lucene.mapper;

import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.lucene.LuceneQueryMapper;
import com.atlassian.confluence.search.v2.lucene.LuceneSearchMapper;
import com.atlassian.confluence.search.v2.query.BooleanQuery;
import java.util.Set;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanQueryMapper
implements LuceneQueryMapper {
    private LuceneSearchMapper searchMapper;

    public Query convertToLuceneQuery(SearchQuery query) {
        BooleanQuery boolQuery = (BooleanQuery)query;
        org.apache.lucene.search.BooleanQuery luceneQuery = new org.apache.lucene.search.BooleanQuery();
        this.addSubQueries(luceneQuery, boolQuery.getMustQueries(), BooleanClause.Occur.MUST);
        this.addSubQueries(luceneQuery, boolQuery.getShouldQueries(), BooleanClause.Occur.SHOULD);
        this.addSubQueries(luceneQuery, boolQuery.getMustNotQueries(), BooleanClause.Occur.MUST_NOT);
        if (luceneQuery.clauses().isEmpty()) {
            return null;
        }
        return luceneQuery;
    }

    private void addSubQueries(org.apache.lucene.search.BooleanQuery luceneQuery, Set<SearchQuery> queries, BooleanClause.Occur operator) {
        for (SearchQuery query : queries) {
            Query mappedQuery = this.searchMapper.convertToLuceneQuery(query);
            if (mappedQuery == null) continue;
            luceneQuery.add(mappedQuery, operator);
        }
    }

    public void setSearchMapper(LuceneSearchMapper searchMapper) {
        this.searchMapper = searchMapper;
    }
}

