/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.v2.lucene.mapper;

import com.atlassian.bonnie.LuceneUtils;
import com.atlassian.confluence.search.v2.lucene.LuceneQueryMapper;
import com.atlassian.confluence.search.v2.query.DateRangeQuery;
import java.util.Date;
import org.apache.lucene.search.ConstantScoreRangeQuery;
import org.apache.lucene.search.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateRangeQueryMapper
implements LuceneQueryMapper<DateRangeQuery> {
    @Override
    public Query convertToLuceneQuery(DateRangeQuery dateRangeQuery) {
        if (!DateRangeQuery.DateRangeQueryType.MODIFIED.equals((Object)dateRangeQuery.getDateRangeQueryType())) {
            throw new IllegalArgumentException("Unsupported date range query type: " + (Object)((Object)dateRangeQuery.getDateRangeQueryType()));
        }
        String fieldName = "modified";
        String lowerBound = null;
        String upperBound = null;
        if (dateRangeQuery.getFromDate() != null) {
            lowerBound = LuceneUtils.dateToString((Date)dateRangeQuery.getFromDate());
        }
        if (dateRangeQuery.getToDate() != null) {
            upperBound = LuceneUtils.dateToString((Date)dateRangeQuery.getToDate());
        }
        return new ConstantScoreRangeQuery(fieldName, lowerBound, upperBound, true, true);
    }
}

