/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.v2.lucene.mapper;

import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.lucene.LuceneQueryMapper;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.user.User;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class PermittedSpacesQueryMapper
implements LuceneQueryMapper {
    private SpaceManager spaceManager;
    public static final String SPACEKEY_FIELD = "spacekey";

    public Query convertToLuceneQuery(SearchQuery searchQuery) {
        BooleanQuery inSpace = new BooleanQuery();
        inSpace.add((Query)new TermQuery(new Term("inSpace", "false")), BooleanClause.Occur.SHOULD);
        inSpace.add(this.getPermittedSpacesQuery(), BooleanClause.Occur.SHOULD);
        inSpace.setMinimumNumberShouldMatch(1);
        return inSpace;
    }

    private Query getPermittedSpacesQuery() {
        User currentUser = AuthenticatedUserThreadLocal.getUser();
        List permittedSpaces = this.spaceManager.getPermittedSpaces(currentUser);
        int requiredClauseCount = Math.max(permittedSpaces.size(), 1024);
        BooleanQuery.setMaxClauseCount((int)Math.max(requiredClauseCount, BooleanQuery.getMaxClauseCount()));
        BooleanQuery query = new BooleanQuery();
        for (Space space : permittedSpaces) {
            query.add((Query)new TermQuery(new Term(SPACEKEY_FIELD, space.getKey())), BooleanClause.Occur.SHOULD);
        }
        query.setMinimumNumberShouldMatch(1);
        return query;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }
}

