/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.v2.lucene.mapper;

import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.search.lucene.MatchNoDocsQuery;
import com.atlassian.confluence.search.service.SpaceCategoryEnum;
import com.atlassian.confluence.search.v2.lucene.LuceneQueryMapper;
import com.atlassian.confluence.search.v2.query.SpaceCategoryQuery;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceType;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.user.User;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpaceCategoryQueryMapper
implements LuceneQueryMapper<SpaceCategoryQuery> {
    public static final String SPACE_TYPE_FIELD = "space.type";
    private LabelManager labelManager;

    @Override
    public Query convertToLuceneQuery(SpaceCategoryQuery spaceCategoryQuery) {
        if (spaceCategoryQuery == null) {
            throw new IllegalArgumentException("Invalid space category query supplied.");
        }
        BooleanQuery convertedQuery = new BooleanQuery();
        block6: for (SpaceCategoryEnum category : spaceCategoryQuery.getSpaceCategories()) {
            switch (category) {
                case ALL: {
                    return null;
                }
                case FAVOURITES: {
                    convertedQuery.add(this.mapFavouritesCategory(), BooleanClause.Occur.SHOULD);
                    continue block6;
                }
                case GLOBAL: {
                    convertedQuery.add(this.mapSpaceTypeQuery(SpaceType.GLOBAL.toString()), BooleanClause.Occur.SHOULD);
                    continue block6;
                }
                case PERSONAL: {
                    convertedQuery.add(this.mapSpaceTypeQuery(SpaceType.PERSONAL.toString()), BooleanClause.Occur.SHOULD);
                    continue block6;
                }
            }
            throw new IllegalArgumentException("Unknown space category: " + (Object)((Object)category));
        }
        if (convertedQuery.clauses().size() == 1) {
            return convertedQuery.getClauses()[0].getQuery();
        }
        return convertedQuery;
    }

    private Query mapSpaceTypeQuery(String spaceType) {
        return new TermQuery(new Term(SPACE_TYPE_FIELD, spaceType));
    }

    private Query mapFavouritesCategory() {
        User currentUser = AuthenticatedUserThreadLocal.getUser();
        if (currentUser == null) {
            return MatchNoDocsQuery.newInstance();
        }
        List favouriteSpaces = this.labelManager.getFavouriteSpaces(currentUser.getName());
        switch (favouriteSpaces.size()) {
            case 0: {
                return MatchNoDocsQuery.newInstance();
            }
            case 1: {
                return new TermQuery(new Term("spacekey", ((Space)favouriteSpaces.get(0)).getKey()));
            }
        }
        return this.makeBooleanQuery(favouriteSpaces);
    }

    private Query makeBooleanQuery(List favouriteSpaces) {
        BooleanQuery query = new BooleanQuery();
        for (Space space : favouriteSpaces) {
            query.add((Query)new TermQuery(new Term("spacekey", space.getKey())), BooleanClause.Occur.SHOULD);
        }
        return query;
    }

    public void setLabelManager(LabelManager labelManager) {
        this.labelManager = labelManager;
    }
}

