/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.v2.lucene.mapper;

import com.atlassian.bonnie.analyzer.LuceneAnalyzerFactory;
import com.atlassian.confluence.search.v2.BooleanOperator;
import com.atlassian.confluence.search.v2.lucene.LuceneQueryMapper;
import com.atlassian.confluence.search.v2.query.TextFieldQuery;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextFieldQueryMapper
implements LuceneQueryMapper<TextFieldQuery> {
    private LuceneAnalyzerFactory luceneAnalyzerFactory;

    @Override
    public Query convertToLuceneQuery(TextFieldQuery textFieldQuery) {
        QueryParser queryParser = new QueryParser(textFieldQuery.getFieldName(), this.luceneAnalyzerFactory.createAnalyzer());
        if (BooleanOperator.AND == textFieldQuery.getOperator()) {
            queryParser.setDefaultOperator(QueryParser.Operator.AND);
        } else if (BooleanOperator.OR == textFieldQuery.getOperator()) {
            queryParser.setDefaultOperator(QueryParser.Operator.OR);
        } else {
            throw new UnsupportedOperationException("Unsupported operator found: " + (Object)((Object)textFieldQuery.getOperator()));
        }
        try {
            return queryParser.parse(textFieldQuery.getRawQuery());
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void setLuceneAnalyzerFactory(LuceneAnalyzerFactory luceneAnalyzerFactory) {
        this.luceneAnalyzerFactory = luceneAnalyzerFactory;
    }
}

